/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.circuits.StreamImpl;
import com.subgraph.orchid.circuits.cells.RelayCellImpl;
import java.io.IOException;
import java.io.OutputStream;

public class TorOutputStream
extends OutputStream {
    private final StreamImpl stream;
    private RelayCell currentOutputCell;
    private volatile boolean isClosed;
    private long bytesSent;

    TorOutputStream(StreamImpl stream) {
        this.stream = stream;
        this.bytesSent = 0L;
    }

    private void flushCurrentOutputCell() {
        if (this.currentOutputCell != null && this.currentOutputCell.cellBytesConsumed() > 14) {
            this.stream.waitForSendWindowAndDecrement();
            this.stream.getCircuit().sendRelayCell(this.currentOutputCell);
            this.bytesSent += (long)(this.currentOutputCell.cellBytesConsumed() - 14);
        }
        this.currentOutputCell = new RelayCellImpl(this.stream.getTargetNode(), this.stream.getCircuit().getCircuitId(), this.stream.getStreamId(), 2);
    }

    long getBytesSent() {
        return this.bytesSent;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkOpen();
        if (this.currentOutputCell == null || this.currentOutputCell.cellBytesRemaining() == 0) {
            this.flushCurrentOutputCell();
        }
        this.currentOutputCell.putByte(b);
    }

    @Override
    public synchronized void write(byte[] data, int offset, int length) throws IOException {
        this.checkOpen();
        if (this.currentOutputCell == null || this.currentOutputCell.cellBytesRemaining() == 0) {
            this.flushCurrentOutputCell();
        }
        while (length > 0) {
            if (length < this.currentOutputCell.cellBytesRemaining()) {
                this.currentOutputCell.putByteArray(data, offset, length);
                return;
            }
            int writeCount = this.currentOutputCell.cellBytesRemaining();
            this.currentOutputCell.putByteArray(data, offset, writeCount);
            this.flushCurrentOutputCell();
            offset += writeCount;
            length -= writeCount;
        }
    }

    private void checkOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("Output stream is closed");
        }
    }

    @Override
    public synchronized void flush() {
        if (this.isClosed) {
            return;
        }
        this.flushCurrentOutputCell();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.flush();
        this.isClosed = true;
        this.currentOutputCell = null;
        this.stream.close();
    }

    public String toString() {
        return "TorOutputStream stream=" + this.stream.getStreamId() + " node=" + this.stream.getTargetNode();
    }
}

