/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.keys;

import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Point;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;
import org.libsodium.jni.keys.PrivateKey;
import org.libsodium.jni.keys.PublicKey;

public class KeyPair {
    private byte[] publicKey;
    private byte[] seed;
    private final byte[] secretKey;

    public KeyPair() {
        this.secretKey = Util.zeros(32);
        this.publicKey = Util.zeros(32);
        NaCl.sodium();
        Sodium.crypto_box_curve25519xsalsa20poly1305_keypair(this.publicKey, this.secretKey);
    }

    public KeyPair(byte[] seed) {
        Util.checkLength(seed, 32);
        this.seed = seed;
        this.secretKey = Util.zeros(32);
        this.publicKey = Util.zeros(32);
        NaCl.sodium();
        Util.isValid(Sodium.crypto_box_curve25519xsalsa20poly1305_seed_keypair(this.publicKey, this.secretKey, seed), "Failed to generate a key pair");
    }

    public KeyPair(String secretKey, Encoder encoder) {
        this(encoder.decode(secretKey));
    }

    public PublicKey getPublicKey() {
        Point point = new Point();
        byte[] key = this.publicKey != null ? this.publicKey : point.mult(this.secretKey).toBytes();
        return new PublicKey(key);
    }

    public PrivateKey getPrivateKey() {
        return new PrivateKey(this.secretKey);
    }
}

