/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt;

import android.os.Build;
import android.os.Environment;
import com.nulabinc.zxcvbn.Zxcvbn;
import java.io.File;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0010\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/pvryan/easycrypt/Constants;", "", "()V", "Companion", "easycrypt_release"})
public class Constants {
    @NotNull
    private static final SecureRandom random;
    @NotNull
    private static final Zxcvbn zxcvbn;
    @NotNull
    private static final String SECRET_KEY_FAC_ALGORITHM;
    @NotNull
    public static final String SECRET_KEY_SPEC_ALGORITHM = "AES";
    public static final int KEY_BITS_LENGTH = 256;
    public static final int SALT_BYTES_LENGTH = 32;
    public static final int ITERATIONS = 10000;
    @NotNull
    public static final String ASYMMETRIC_ALGORITHM = "RSA";
    @NotNull
    public static final String ASYMMETRIC_TRANSFORMATION = "RSA/NONE/OAEPwithSHA-256andMGF1Padding";
    @NotNull
    public static final String SIGNATURE_ALGORITHM = "SHA512withRSA";
    private static final String HASH_FILE_EXT = ".txt";
    @NotNull
    public static final String ECRYPT_FILE_EXT = ".ecrypt";
    private static final String HASH_FILE_NAME = "HashOfFile";
    @NotNull
    public static final String ENCRYPTED_FILE_NAME = "EncryptedFile";
    private static final String DECRYPTED_FILE_NAME = "DecryptedFile";
    private static final String TEMP_DIR_NAME = ".ecrypt";
    @NotNull
    private static final String DEF_EXT_TEMP_DIR_PATH;
    private static final String DEF_EXT_FILE_PATH;
    @NotNull
    private static final String DEF_HASH_FILE_PATH;
    @NotNull
    private static final String DEF_ENCRYPTED_FILE_PATH;
    @NotNull
    private static final String DEF_DECRYPTED_FILE_PATH;
    @NotNull
    public static final String ERR_INVALID_KEY = "The key is not valid. Please provide a valid RSA key.";
    @NotNull
    public static final String ERR_VERIFY_EXCEPTION = "Cannot use provided signature to verify input data.";
    @NotNull
    public static final String ERR_SIGN_EXCEPTION = "This signature algorithm is unable to process the input data provided.";
    @NotNull
    public static final String ERR_INPUT_TYPE_NOT_SUPPORTED = "Input type not supported.";
    @NotNull
    public static final String ERR_INVALID_INPUT_DATA = "Invalid input data.";
    @NotNull
    public static final String ERR_NO_SUCH_FILE = "File does not exist.";
    @NotNull
    public static final String ERR_CANNOT_WRITE = "Cannot write to file.";
    @NotNull
    public static final String ERR_CANNOT_READ = "Cannot read from file.";
    @NotNull
    public static final String ERR_OUTPUT_FILE_EXISTS = "Output file already exists.";
    @NotNull
    public static final String ERR_BAD_BASE64 = "Invalid base64 string.";
    @NotNull
    public static final String STANDARD_SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    public static final int PASSWORD_LENGTH = 24;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        random = new SecureRandom();
        zxcvbn = new Zxcvbn();
        SECRET_KEY_FAC_ALGORITHM = Build.VERSION.SDK_INT < 26 ? "PBKDF2WithHmacSHA1" : "PBEwithHmacSHA512AndAES_256";
        StringBuilder stringBuilder = new StringBuilder();
        File file = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"Environment.getExternalStorageDirectory()");
        DEF_EXT_TEMP_DIR_PATH = stringBuilder.append(file.getAbsolutePath()).append(File.separator).append(".ecrypt").toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        File file2 = Environment.getExternalStorageDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"Environment.getExternalStorageDirectory()");
        DEF_EXT_FILE_PATH = stringBuilder2.append(file2.getAbsolutePath()).append(File.separator).toString();
        DEF_HASH_FILE_PATH = Constants.Companion.getDEF_EXT_FILE_PATH() + HASH_FILE_NAME + HASH_FILE_EXT;
        DEF_ENCRYPTED_FILE_PATH = Constants.Companion.getDEF_EXT_FILE_PATH() + ENCRYPTED_FILE_NAME + ".ecrypt";
        DEF_DECRYPTED_FILE_PATH = Constants.Companion.getDEF_EXT_FILE_PATH() + DECRYPTED_FILE_NAME + ".ecrypt";
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\tR\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00063"}, d2={"Lcom/pvryan/easycrypt/Constants$Companion;", "", "()V", "ASYMMETRIC_ALGORITHM", "", "ASYMMETRIC_TRANSFORMATION", "DECRYPTED_FILE_NAME", "DEF_DECRYPTED_FILE_PATH", "getDEF_DECRYPTED_FILE_PATH", "()Ljava/lang/String;", "DEF_ENCRYPTED_FILE_PATH", "getDEF_ENCRYPTED_FILE_PATH", "DEF_EXT_FILE_PATH", "getDEF_EXT_FILE_PATH", "DEF_EXT_TEMP_DIR_PATH", "getDEF_EXT_TEMP_DIR_PATH", "DEF_HASH_FILE_PATH", "getDEF_HASH_FILE_PATH", "ECRYPT_FILE_EXT", "ENCRYPTED_FILE_NAME", "ERR_BAD_BASE64", "ERR_CANNOT_READ", "ERR_CANNOT_WRITE", "ERR_INPUT_TYPE_NOT_SUPPORTED", "ERR_INVALID_INPUT_DATA", "ERR_INVALID_KEY", "ERR_NO_SUCH_FILE", "ERR_OUTPUT_FILE_EXISTS", "ERR_SIGN_EXCEPTION", "ERR_VERIFY_EXCEPTION", "HASH_FILE_EXT", "HASH_FILE_NAME", "ITERATIONS", "", "KEY_BITS_LENGTH", "PASSWORD_LENGTH", "SALT_BYTES_LENGTH", "SECRET_KEY_FAC_ALGORITHM", "getSECRET_KEY_FAC_ALGORITHM", "SECRET_KEY_SPEC_ALGORITHM", "SIGNATURE_ALGORITHM", "STANDARD_SYMBOLS", "TEMP_DIR_NAME", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "zxcvbn", "Lcom/nulabinc/zxcvbn/Zxcvbn;", "getZxcvbn", "()Lcom/nulabinc/zxcvbn/Zxcvbn;", "easycrypt_release"})
    public static final class Companion {
        @NotNull
        public final SecureRandom getRandom() {
            return random;
        }

        @NotNull
        public final Zxcvbn getZxcvbn() {
            return zxcvbn;
        }

        @NotNull
        public final String getSECRET_KEY_FAC_ALGORITHM() {
            return SECRET_KEY_FAC_ALGORITHM;
        }

        @NotNull
        public final String getDEF_EXT_TEMP_DIR_PATH() {
            return DEF_EXT_TEMP_DIR_PATH;
        }

        private final String getDEF_EXT_FILE_PATH() {
            return DEF_EXT_FILE_PATH;
        }

        @NotNull
        public final String getDEF_HASH_FILE_PATH() {
            return DEF_HASH_FILE_PATH;
        }

        @NotNull
        public final String getDEF_ENCRYPTED_FILE_PATH() {
            return DEF_ENCRYPTED_FILE_PATH;
        }

        @NotNull
        public final String getDEF_DECRYPTED_FILE_PATH() {
            return DEF_DECRYPTED_FILE_PATH;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

