/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.RouterStatus;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.Timestamp;
import com.subgraph.orchid.data.exitpolicy.ExitPorts;
import java.util.HashSet;
import java.util.Set;

public class RouterStatusImpl
implements RouterStatus {
    private String nickname;
    private HexDigest identity;
    private HexDigest digest;
    private HexDigest microdescriptorDigest;
    private Timestamp publicationTime;
    private IPv4Address address;
    private int routerPort;
    private int directoryPort;
    private Set<String> flags = new HashSet<String>();
    private String version;
    private int bandwidthEstimate;
    private int bandwidthMeasured;
    private boolean hasBandwidth;
    private ExitPorts exitPorts;

    void setNickname(String nickname) {
        this.nickname = nickname;
    }

    void setIdentity(HexDigest identity) {
        this.identity = identity;
    }

    void setDigest(HexDigest digest) {
        this.digest = digest;
    }

    void setMicrodescriptorDigest(HexDigest digest) {
        this.microdescriptorDigest = digest;
    }

    void setPublicationTime(Timestamp timestamp) {
        this.publicationTime = timestamp;
    }

    void setAddress(IPv4Address address) {
        this.address = address;
    }

    void setRouterPort(int port) {
        this.routerPort = port;
    }

    void setDirectoryPort(int port) {
        this.directoryPort = port;
    }

    void addFlag(String flag) {
        this.flags.add(flag);
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setEstimatedBandwidth(int bandwidth) {
        this.bandwidthEstimate = bandwidth;
        this.hasBandwidth = true;
    }

    void setMeasuredBandwidth(int bandwidth) {
        this.bandwidthMeasured = bandwidth;
    }

    void setAcceptedPorts(String portList) {
        this.exitPorts = ExitPorts.createAcceptExitPorts(portList);
    }

    void setRejectedPorts(String portList) {
        this.exitPorts = ExitPorts.createRejectExitPorts(portList);
    }

    public String toString() {
        return "Router: (" + this.nickname + " " + this.identity + " " + this.digest + " " + this.address + " " + this.routerPort + " " + this.directoryPort + " " + this.version + " " + this.exitPorts + ")";
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public HexDigest getIdentity() {
        return this.identity;
    }

    @Override
    public HexDigest getDescriptorDigest() {
        return this.digest;
    }

    @Override
    public HexDigest getMicrodescriptorDigest() {
        return this.microdescriptorDigest;
    }

    @Override
    public Timestamp getPublicationTime() {
        return this.publicationTime;
    }

    @Override
    public IPv4Address getAddress() {
        return this.address;
    }

    @Override
    public int getRouterPort() {
        return this.routerPort;
    }

    @Override
    public boolean isDirectory() {
        return this.directoryPort != 0;
    }

    @Override
    public int getDirectoryPort() {
        return this.directoryPort;
    }

    @Override
    public boolean hasFlag(String flag) {
        return this.flags.contains(flag);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean hasBandwidth() {
        return this.hasBandwidth;
    }

    @Override
    public int getEstimatedBandwidth() {
        return this.bandwidthEstimate;
    }

    @Override
    public int getMeasuredBandwidth() {
        return this.bandwidthMeasured;
    }

    @Override
    public ExitPorts getExitPorts() {
        return this.exitPorts;
    }
}

