/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.hash;

import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import com.pvryan.easycrypt.hash.ECHashAlgorithms;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoAsyncContext;
import org.jetbrains.anko.AsyncKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\b\b\u0001\u0010\u0006\u001a\u0002H\u00052\b\b\u0003\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0003\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/pvryan/easycrypt/hash/ECHash;", "", "()V", "calculate", "", "T", "input", "algorithm", "Lcom/pvryan/easycrypt/hash/ECHashAlgorithms;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "(Ljava/lang/Object;Lcom/pvryan/easycrypt/hash/ECHashAlgorithms;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "easycrypt_release"})
public final class ECHash {
    @JvmOverloads
    public final <T> void calculate(@NotNull T input, @NotNull ECHashAlgorithms algorithm, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        AsyncKt.doAsync$default((Object)this, null, (Function1)((Function1)new Function1<AnkoAsyncContext<ECHash>, Unit>(this, algorithm, input, erl, outputFile){
            final /* synthetic */ ECHash this$0;
            final /* synthetic */ ECHashAlgorithms $algorithm;
            final /* synthetic */ Object $input;
            final /* synthetic */ ECResultListener $erl;
            final /* synthetic */ File $outputFile;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull AnkoAsyncContext<ECHash> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                MessageDigest messageDigest = MessageDigest.getInstance(this.$algorithm.getValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)messageDigest, (String)"MessageDigest.getInstance(algorithm.value)");
                MessageDigest digest = messageDigest;
                Object object = this.$input;
                if (object instanceof String) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray((String)this.$input);
                    ECHash eCHash = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCHash.calculate(byteArrayInputStream, this.$algorithm, this.$erl, this.$outputFile);
                } else if (object instanceof CharSequence) {
                    byte[] byArray = DataTypeExtensionsKt.asByteArray(this.$input.toString());
                    ECHash eCHash = this.this$0;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    eCHash.calculate(byteArrayInputStream, this.$algorithm, this.$erl, this.$outputFile);
                } else if (object instanceof File) {
                    File file = (File)this.$input;
                    ECHash eCHash = this.this$0;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    eCHash.calculate(fileInputStream, this.$algorithm, this.$erl, this.$outputFile);
                } else if (object instanceof byte[]) {
                    byte[] byArray = digest.digest((byte[])this.$input);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest(input)");
                    String hash = DataTypeExtensionsKt.asHexString(byArray);
                    if (Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_HASH_FILE_PATH()) ^ true) {
                        Object object2 = this.$outputFile;
                        object2 = new FileOutputStream((File)object2);
                        Throwable throwable = null;
                        try {
                            FileOutputStream it = (FileOutputStream)object2;
                            it.write(DataTypeExtensionsKt.asByteArray(hash));
                            it.flush();
                            it = Unit.INSTANCE;
                        }
                        catch (Throwable it) {
                            throwable = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                        }
                        this.$erl.onSuccess(this.$outputFile);
                    } else {
                        this.$erl.onSuccess(hash);
                    }
                } else if (object instanceof InputStream) {
                    byte[] buffer = new byte[8192];
                    if (((InputStream)this.$input).available() <= buffer.length) {
                        this.this$0.calculate(ByteStreamsKt.readBytes$default((InputStream)((InputStream)this.$input), (int)0, (int)1, null), this.$algorithm, this.$erl, this.$outputFile);
                        return;
                    }
                    try {
                        long size = this.$input instanceof FileInputStream ? ((FileInputStream)this.$input).getChannel().size() : -1L;
                        long bytesCopied = 0L;
                        int read = ((InputStream)this.$input).read(buffer);
                        while (read > -1) {
                            digest.update(buffer, 0, read);
                            this.$erl.onProgress(read, bytesCopied += (long)read, size);
                            read = ((InputStream)this.$input).read(buffer);
                        }
                        byte[] byArray = digest.digest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest()");
                        String hash = DataTypeExtensionsKt.asHexString(byArray);
                        if (Intrinsics.areEqual((Object)this.$outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_HASH_FILE_PATH()) ^ true) {
                            Object object3 = this.$outputFile;
                            object3 = new FileOutputStream((File)object3);
                            Throwable throwable = null;
                            try {
                                FileOutputStream it = (FileOutputStream)object3;
                                it.write(DataTypeExtensionsKt.asByteArray(hash));
                                it.flush();
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                            }
                            this.$erl.onSuccess(this.$outputFile);
                        }
                        this.$erl.onSuccess(hash);
                    }
                    catch (IOException e) {
                        this.$erl.onFailure("Cannot read from file.", e);
                    }
                    finally {
                        ((InputStream)this.$input).close();
                    }
                } else {
                    this.$erl.onFailure("Input type not supported.", new InvalidParameterException());
                }
            }
            {
                this.this$0 = eCHash;
                this.$algorithm = eCHashAlgorithms;
                this.$input = object;
                this.$erl = eCResultListener;
                this.$outputFile = file;
                super(1);
            }
        }), (int)1, null);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void calculate$default(ECHash eCHash, Object object, ECHashAlgorithms eCHashAlgorithms, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 2) != 0) {
            eCHashAlgorithms = ECHashAlgorithms.SHA_512;
        }
        if ((n & 8) != 0) {
            file = new File(Constants.Companion.getDEF_HASH_FILE_PATH());
        }
        eCHash.calculate(object, eCHashAlgorithms, eCResultListener, file);
    }

    @JvmOverloads
    public final <T> void calculate(@NotNull T input, @NotNull ECHashAlgorithms algorithm, @NotNull ECResultListener erl) {
        ECHash.calculate$default(this, input, algorithm, erl, null, 8, null);
    }

    @JvmOverloads
    public final <T> void calculate(@NotNull T input, @NotNull ECResultListener erl) {
        ECHash.calculate$default(this, input, null, erl, null, 10, null);
    }
}

