/*
 * Decompiled with CFR 0.152.
 */
package com.pvryan.easycrypt.asymmetric;

import com.pvryan.easycrypt.Constants;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.asymmetric.performDecrypt;
import com.pvryan.easycrypt.extensions.DataTypeExtensionsKt;
import com.pvryan.easycrypt.symmetric.ECSymmetric;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/pvryan/easycrypt/asymmetric/performDecrypt;", "", "()V", "invoke", "", "T", "input", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "cipher", "Ljavax/crypto/Cipher;", "erl", "Lcom/pvryan/easycrypt/ECResultListener;", "outputFile", "Ljava/io/File;", "invoke$easycrypt_release", "(Ljava/lang/Object;Ljava/security/interfaces/RSAPrivateKey;Ljavax/crypto/Cipher;Lcom/pvryan/easycrypt/ECResultListener;Ljava/io/File;)V", "easycrypt_release"})
public final class performDecrypt {
    public static final performDecrypt INSTANCE;

    public final /* synthetic */ <T> void invoke$easycrypt_release(T input, @NotNull RSAPrivateKey privateKey, @NotNull Cipher cipher, @NotNull ECResultListener erl, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)cipher, (String)"cipher");
        Intrinsics.checkParameterIsNotNull((Object)erl, (String)"erl");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        if (outputFile.exists() && Intrinsics.areEqual((Object)outputFile.getAbsolutePath(), (Object)Constants.Companion.getDEF_DECRYPTED_FILE_PATH()) ^ true) {
            T t = input;
            if (t instanceof InputStream) {
                ((InputStream)input).close();
            }
            erl.onFailure("Output file already exists.", (Exception)new FileAlreadyExistsException(outputFile, null, null, 6, null));
            return;
        }
        int RSA_OUTPUT_SIZE = DataTypeExtensionsKt.size(privateKey) / 8;
        T t = input;
        if (t instanceof byte[]) {
            if (((byte[])input).length > RSA_OUTPUT_SIZE) {
                byte[] passBytes = new byte[RSA_OUTPUT_SIZE];
                byte[] byArray = (byte[])input;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
                inputStream.read(passBytes);
                this.invoke$easycrypt_release(passBytes, privateKey, cipher, new ECResultListener(inputStream, erl, outputFile){
                    final /* synthetic */ ByteArrayInputStream $inputStream;
                    final /* synthetic */ ECResultListener $erl;
                    final /* synthetic */ File $outputFile;

                    public <T> void onSuccess(T password) {
                        T t = password;
                        if (t == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                        }
                        ECSymmetric.decrypt$default(new ECSymmetric(null, 1, null), this.$inputStream, (String)t, new ECResultListener(this){
                            final /* synthetic */ invoke.1 this$0;

                            public <T> void onSuccess(T result) {
                                T t = result;
                                if (t == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                                }
                                DataTypeExtensionsKt.handleSuccess(DataTypeExtensionsKt.asByteArray((String)t), this.this$0.$erl, this.this$0.$outputFile, false);
                            }

                            public void onFailure(@NotNull String message, @NotNull Exception e) {
                                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                this.this$0.$erl.onFailure(message, e);
                            }
                            {
                                this.this$0 = $outer;
                            }

                            public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                                ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                            }
                        }, null, 8, null);
                    }

                    public void onFailure(@NotNull String message, @NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        this.$inputStream.close();
                        this.$erl.onFailure(message, e);
                    }
                    {
                        this.$inputStream = $captured_local_variable$0;
                        this.$erl = $captured_local_variable$1;
                        this.$outputFile = $captured_local_variable$2;
                    }

                    public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                        ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                    }
                }, outputFile);
            } else {
                try {
                    byte[] byArray = cipher.doFinal((byte[])input);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(input)");
                    DataTypeExtensionsKt.handleSuccess(byArray, erl, outputFile, false);
                }
                catch (BadPaddingException e) {
                    erl.onFailure("Invalid input data.", e);
                }
                catch (IllegalBlockSizeException e) {
                    erl.onFailure("Invalid input data.", e);
                }
            }
        } else if (t instanceof FileInputStream) {
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            byte[] passCipher = new byte[RSA_OUTPUT_SIZE];
            ((FileInputStream)input).read(passCipher);
            performDecrypt.invoke$easycrypt_release$default(this, passCipher, privateKey, cipher, new ECResultListener(input, erl, outputFile){
                final /* synthetic */ Object $input;
                final /* synthetic */ ECResultListener $erl;
                final /* synthetic */ File $outputFile;

                public <T> void onSuccess(T password) {
                    T t = password;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    new ECSymmetric(null, 1, null).decrypt(this.$input, (String)t, new ECResultListener(this){
                        final /* synthetic */ invoke.2 this$0;

                        public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                            this.this$0.$erl.onProgress(newBytes, bytesProcessed, totalBytes);
                        }

                        public <T> void onSuccess(T result) {
                            this.this$0.$erl.onSuccess(result);
                        }

                        public void onFailure(@NotNull String message, @NotNull Exception e) {
                            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                            this.this$0.$erl.onFailure(message, e);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }, this.$outputFile);
                }

                public void onFailure(@NotNull String message, @NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    ((FileInputStream)this.$input).close();
                    this.$erl.onFailure(message, e);
                }
                {
                    this.$input = $captured_local_variable$0;
                    this.$erl = $captured_local_variable$1;
                    this.$outputFile = $captured_local_variable$2;
                }

                public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                    ECResultListener.DefaultImpls.onProgress(this, newBytes, bytesProcessed, totalBytes);
                }
            }, null, 16, null);
        } else {
            erl.onFailure("Input type not supported.", new InvalidParameterException());
        }
    }

    public static /* bridge */ /* synthetic */ void invoke$easycrypt_release$default(performDecrypt performDecrypt2, Object object, RSAPrivateKey rSAPrivateKey, Cipher cipher, ECResultListener eCResultListener, File file, int n, Object object2) {
        if ((n & 0x10) != 0) {
            file = new File(Constants.Companion.getDEF_DECRYPTED_FILE_PATH());
        }
        performDecrypt2.invoke$easycrypt_release(object, rSAPrivateKey, cipher, eCResultListener, file);
    }

    private performDecrypt() {
    }

    static {
        performDecrypt performDecrypt2;
        INSTANCE = performDecrypt2 = new performDecrypt();
    }
}

