/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.data;

import java.util.concurrent.Semaphore;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import milfont.com.tezosj_android.data.BaseGateway;
import milfont.com.tezosj_android.data.PocketProvider;
import milfont.com.tezosj_android.data.TezosNetwork;
import milfont.com.tezosj_android.helper.SemaphoreUtil;
import network.pocket.core.errors.PocketError;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PocketGateway
extends BaseGateway {
    private String devID;
    private TezosNetwork netID;
    private int timeout = 20000;
    private PocketProvider pocket;
    private final String TEZOS_NETWORK = "TEZOS";

    public PocketGateway(@NotNull String devID, @NotNull TezosNetwork netID, int timeout) {
        this.devID = devID;
        this.netID = netID;
        this.timeout = timeout;
        this.pocket = new PocketProvider(devID, "TEZOS", new String[]{this.netID.name()}, 5, this.timeout);
    }

    @Override
    Object query(String endpoint, String data) throws Exception {
        PocketGatewaySemaphoreCallback callback = new PocketGatewaySemaphoreCallback(endpoint, data);
        SemaphoreUtil.executeSemaphoreCallback(callback);
        return callback.getResult();
    }

    class PocketGatewaySemaphoreCallback
    implements SemaphoreUtil.SemaphoreCallback,
    Function2<PocketError, String, Unit> {
        private String endpoint;
        private String data;
        private JSONObject result;
        private Semaphore semaphore;

        public PocketGatewaySemaphoreCallback(String endpoint, String data) {
            this.endpoint = endpoint;
            this.data = data;
        }

        public JSONObject getResult() {
            return this.result;
        }

        public Unit invoke(PocketError pocketError, String response) {
            try {
                if (PocketGateway.this.isJSONObject(response).booleanValue()) {
                    this.result = new JSONObject(response);
                } else if (PocketGateway.this.isJSONArray(response).booleanValue()) {
                    JSONArray myJSONArray = new JSONArray(response);
                    this.result = new JSONObject();
                    this.result.put("result", (Object)myJSONArray);
                } else {
                    this.result = new JSONObject();
                    this.result.put("result", (Object)response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.result = new JSONObject();
                try {
                    this.result.put("result", (Object)e.toString());
                }
                catch (JSONException jsonException) {
                    jsonException.printStackTrace();
                }
            }
            this.semaphore.release();
            return null;
        }

        @Override
        public void execute(Semaphore semaphore) {
            this.semaphore = semaphore;
            String httpMethod = "POST";
            if (this.data == null) {
                httpMethod = "GET";
            }
            PocketGateway.this.pocket.send("TEZOS", PocketGateway.this.netID.name(), this.data, httpMethod, this.endpoint, null, null, this);
        }
    }
}

