/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.DirectoryStore;
import com.subgraph.orchid.Document;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.directory.DirectoryStoreFile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectoryStoreImpl
implements DirectoryStore {
    private final TorConfig config;
    private Map<DirectoryStore.CacheFile, DirectoryStoreFile> fileMap;

    DirectoryStoreImpl(TorConfig config) {
        this.config = config;
        this.fileMap = new HashMap<DirectoryStore.CacheFile, DirectoryStoreFile>();
    }

    @Override
    public synchronized ByteBuffer loadCacheFile(DirectoryStore.CacheFile cacheFile) {
        return this.getStoreFile(cacheFile).loadContents();
    }

    @Override
    public synchronized void writeData(DirectoryStore.CacheFile cacheFile, ByteBuffer data) {
        this.getStoreFile(cacheFile).writeData(data);
    }

    @Override
    public synchronized void writeDocument(DirectoryStore.CacheFile cacheFile, Document document) {
        this.writeDocumentList(cacheFile, Arrays.asList(document));
    }

    @Override
    public synchronized void writeDocumentList(DirectoryStore.CacheFile cacheFile, List<? extends Document> documents) {
        this.getStoreFile(cacheFile).writeDocuments(documents);
    }

    @Override
    public synchronized void appendDocumentList(DirectoryStore.CacheFile cacheFile, List<? extends Document> documents) {
        this.getStoreFile(cacheFile).appendDocuments(documents);
    }

    @Override
    public synchronized void removeCacheFile(DirectoryStore.CacheFile cacheFile) {
        this.getStoreFile(cacheFile).remove();
    }

    @Override
    public synchronized void removeAllCacheFiles() {
        for (DirectoryStore.CacheFile cf : DirectoryStore.CacheFile.values()) {
            this.getStoreFile(cf).remove();
        }
    }

    private DirectoryStoreFile getStoreFile(DirectoryStore.CacheFile cacheFile) {
        if (!this.fileMap.containsKey((Object)cacheFile)) {
            this.fileMap.put(cacheFile, new DirectoryStoreFile(this.config, cacheFile.getFilename()));
        }
        return this.fileMap.get((Object)cacheFile);
    }
}

