/*
 * Decompiled with CFR 0.152.
 */
package network.pocket.core.model;

import android.content.Context;
import com.orhanobut.hawk.Hawk;
import com.pvryan.easycrypt.ECResultListener;
import com.pvryan.easycrypt.symmetric.ECSymmetric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import network.pocket.core.errors.WalletPersistenceError;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0003J?\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172'\u0010\u001d\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001b0\u001ej\u0002`#R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\t\"\u0004\b\u0013\u0010\u000b\u00a8\u0006%"}, d2={"Lnetwork/pocket/core/model/Wallet;", "Lorg/json/JSONObject;", "privateKey", "", "address", "network", "netID", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAddress", "()Ljava/lang/String;", "setAddress", "(Ljava/lang/String;)V", "crypto", "Lcom/pvryan/easycrypt/symmetric/ECSymmetric;", "getNetID", "setNetID", "getNetwork", "setNetwork", "getPrivateKey", "setPrivateKey", "delete", "", "context", "Landroid/content/Context;", "isSaved", "recordKey", "save", "", "passphrase", "listener", "Lkotlin/Function1;", "Lnetwork/pocket/core/errors/WalletPersistenceError;", "Lkotlin/ParameterName;", "name", "walletPersistenceError", "Lnetwork/pocket/core/model/WalletSaveListener;", "Companion", "pocket-android-core_release"})
public class Wallet
extends JSONObject {
    private final ECSymmetric crypto;
    @NotNull
    private String privateKey;
    @NotNull
    private String address;
    @NotNull
    private String network;
    @NotNull
    private String netID;
    private static final String walletRecordKeysKey = "POCKET_WALLETS_RECORD_KEYS";
    private static final String addressKey = "address";
    private static final String privateKeyKey = "privateKey";
    private static final String networkKey = "network";
    private static final String netIDKey = "netID";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String recordKey() {
        return Wallet.Companion.recordKey(this.network, this.netID, this.address);
    }

    public final void save(@NotNull String passphrase, @NotNull Context context, @NotNull Function1<? super WalletPersistenceError, Unit> listener) throws WalletPersistenceError {
        Intrinsics.checkParameterIsNotNull((Object)passphrase, (String)"passphrase");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        if (this.isSaved(context)) {
            throw (Throwable)new WalletPersistenceError("Wallet already exists");
        }
        String recordKey = this.recordKey();
        ECSymmetric.encrypt$default((ECSymmetric)this.crypto, (Object)this.toString(), (String)passphrase, (ECResultListener)new ECResultListener(context, recordKey, listener){
            final /* synthetic */ Context $context;
            final /* synthetic */ String $recordKey;
            final /* synthetic */ Function1 $listener;

            public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
            }

            public <T> void onSuccess(T result) {
                T t = result;
                if (t == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String encryptedWalletJSON = (String)t;
                Hawk.init((Context)this.$context).build();
                Hawk.put((String)this.$recordKey, (Object)encryptedWalletJSON);
                JSONArray recordKeys = (JSONArray)Hawk.get((String)"POCKET_WALLETS_RECORD_KEYS", (Object)new JSONArray());
                recordKeys.put((Object)this.$recordKey);
                Hawk.put((String)"POCKET_WALLETS_RECORD_KEYS", (Object)recordKeys);
                this.$listener.invoke(null);
            }

            public void onFailure(@NotNull String message, @NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string = e.getMessage();
                if (string == null) {
                    string = "Error encrypting wallet data";
                }
                this.$listener.invoke((Object)new WalletPersistenceError(string));
            }
            {
                this.$context = $captured_local_variable$0;
                this.$recordKey = $captured_local_variable$1;
                this.$listener = $captured_local_variable$2;
            }
        }, null, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean delete(@NotNull Context context) throws WalletPersistenceError {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!this.isSaved(context)) {
            throw (Throwable)new WalletPersistenceError("Wallet has not been saved yet");
        }
        Hawk.init((Context)context).build();
        String recordKey = this.recordKey();
        JSONArray recordKeys = (JSONArray)Hawk.get((String)walletRecordKeysKey, (Object)new JSONArray());
        int n = 0;
        int n2 = recordKeys.length();
        while (n < n2) {
            void i;
            try {
                if (Intrinsics.areEqual((Object)recordKeys.getString((int)i), (Object)recordKey)) {
                    recordKeys.remove((int)i);
                    Hawk.put((String)walletRecordKeysKey, (Object)recordKeys);
                    break;
                }
            }
            catch (JSONException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Error updating the record key list";
                }
                throw (Throwable)new WalletPersistenceError(string);
            }
            ++i;
        }
        return Hawk.delete((String)recordKey);
    }

    public final boolean isSaved(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return Companion.isSaved(this.network, this.netID, this.address, context);
    }

    @NotNull
    public final String getPrivateKey() {
        return this.privateKey;
    }

    public final void setPrivateKey(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.privateKey = string;
    }

    @NotNull
    public final String getAddress() {
        return this.address;
    }

    public final void setAddress(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.address = string;
    }

    @NotNull
    public final String getNetwork() {
        return this.network;
    }

    public final void setNetwork(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.network = string;
    }

    @NotNull
    public final String getNetID() {
        return this.netID;
    }

    public final void setNetID(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.netID = string;
    }

    public Wallet(@NotNull String privateKey, @NotNull String address, @NotNull String network, @NotNull String netID) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)privateKeyKey);
        Intrinsics.checkParameterIsNotNull((Object)address, (String)addressKey);
        Intrinsics.checkParameterIsNotNull((Object)network, (String)networkKey);
        Intrinsics.checkParameterIsNotNull((Object)netID, (String)netIDKey);
        this.privateKey = privateKey;
        this.address = address;
        this.network = network;
        this.netID = netID;
        this.crypto = new ECSymmetric(null, 1, null);
        this.put(addressKey, this.address);
        this.put(privateKeyKey, this.privateKey);
        this.put(networkKey, this.network);
        this.put(netIDKey, this.netID);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002Jn\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2>\u0010\u0016\u001a:\u0012\u0015\u0012\u0013\u0018\u00010\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0015\u0012\u0013\u0018\u00010\u001c\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00140\u0017j\u0002`\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnetwork/pocket/core/model/Wallet$Companion;", "", "()V", "addressKey", "", "netIDKey", "networkKey", "privateKeyKey", "walletRecordKeysKey", "getWalletsRecordKeys", "", "context", "Landroid/content/Context;", "isSaved", "", "network", "netID", "address", "recordKey", "retrieve", "", "passphrase", "listener", "Lkotlin/Function2;", "Lnetwork/pocket/core/errors/WalletPersistenceError;", "Lkotlin/ParameterName;", "name", "walletPersistenceError", "Lnetwork/pocket/core/model/Wallet;", "wallet", "Lnetwork/pocket/core/model/WalletRetrieveListener;", "pocket-android-core_release"})
    public static final class Companion {
        private final String recordKey(String network, String netID, String address) {
            return network + '/' + netID + '/' + address;
        }

        public final boolean isSaved(@NotNull String network, @NotNull String netID, @NotNull String address, @NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)network, (String)Wallet.networkKey);
            Intrinsics.checkParameterIsNotNull((Object)netID, (String)Wallet.netIDKey);
            Intrinsics.checkParameterIsNotNull((Object)address, (String)Wallet.addressKey);
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Hawk.init((Context)context).build();
            return Hawk.contains((String)Companion.recordKey(network, netID, address));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getWalletsRecordKeys(@NotNull Context context) throws WalletPersistenceError {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Hawk.init((Context)context).build();
            JSONArray recordKeys = (JSONArray)Hawk.get((String)Wallet.walletRecordKeysKey, (Object)new JSONArray());
            List recordKeysList = new ArrayList();
            int n = 0;
            int n2 = recordKeys.length();
            while (n < n2) {
                void i;
                try {
                    String string = recordKeys.getString((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recordKeys.getString(i)");
                    recordKeysList.add(string);
                }
                catch (JSONException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Error getting wallet record keys";
                    }
                    throw (Throwable)new WalletPersistenceError(string);
                }
                ++i;
            }
            return recordKeysList;
        }

        public final void retrieve(@NotNull String network, @NotNull String netID, @NotNull String address, @NotNull String passphrase, @NotNull Context context, @NotNull Function2<? super WalletPersistenceError, ? super Wallet, Unit> listener) throws WalletPersistenceError {
            String encryptedWalletJson;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)Wallet.networkKey);
            Intrinsics.checkParameterIsNotNull((Object)netID, (String)Wallet.netIDKey);
            Intrinsics.checkParameterIsNotNull((Object)address, (String)Wallet.addressKey);
            Intrinsics.checkParameterIsNotNull((Object)passphrase, (String)"passphrase");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
            if (!Companion.isSaved(network, netID, address, context)) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "No wallet found for Network %s and Address %s";
                Object[] objectArray = new Object[]{network, address};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string = string3;
                throw (Throwable)new WalletPersistenceError(string4);
            }
            String recordKey = Companion.recordKey(network, netID, address);
            Hawk.init((Context)context).build();
            Object object = Hawk.get((String)recordKey);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Hawk.get(recordKey)");
            String string = encryptedWalletJson = (String)object;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    throw (Throwable)new WalletPersistenceError("Error retrieving wallet from local storage");
                }
            }
            String encryptedJSON = encryptedWalletJson;
            ECSymmetric crypto = new ECSymmetric(null, 1, null);
            ECSymmetric.decrypt$default((ECSymmetric)crypto, (Object)encryptedJSON, (String)passphrase, (ECResultListener)new ECResultListener(listener){
                final /* synthetic */ Function2 $listener;

                public void onProgress(int newBytes, long bytesProcessed, long totalBytes) {
                }

                public <T> void onSuccess(T result) {
                    T t = result;
                    if (t == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String decryptedWalletJSON = (String)t;
                    try {
                        JSONObject decryptedJSONWallet = new JSONObject(decryptedWalletJSON);
                        String privateKey = decryptedJSONWallet.getString("privateKey");
                        String address = decryptedJSONWallet.getString("address");
                        String network = decryptedJSONWallet.getString("network");
                        String netID = decryptedJSONWallet.getString("netID");
                        String string = privateKey;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"privateKey");
                        String string2 = address;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"address");
                        String string3 = network;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"network");
                        String string4 = netID;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"netID");
                        this.$listener.invoke(null, (Object)((Object)new Wallet(string, string2, string3, string4)));
                    }
                    catch (JSONException jsonEx) {
                        String string = jsonEx.getMessage();
                        if (string == null) {
                            string = "Error decrypting wallet data";
                        }
                        this.$listener.invoke((Object)new WalletPersistenceError(string), null);
                    }
                }

                public void onFailure(@NotNull String message, @NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$listener.invoke((Object)new WalletPersistenceError(message), null);
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            }, null, (int)8, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

