/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.keys;

import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;

public class PublicKey {
    private final byte[] publicKey;

    public PublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
        Util.checkLength(publicKey, 32);
    }

    public PublicKey(String publicKey) {
        this.publicKey = Encoder.HEX.decode(publicKey);
    }

    public byte[] toBytes() {
        return this.publicKey;
    }

    public String toString() {
        return Encoder.HEX.encode(this.publicKey);
    }
}

