/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.protocols.channels.PaymentChannelServer;
import org.bitcoinj.protocols.channels.StateMachine;
import org.bitcoinj.protocols.channels.StoredPaymentChannelServerStates;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.script.Script;
import org.bitcoinj.wallet.SendRequest;
import org.bitcoinj.wallet.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaymentChannelServerState {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelServerState.class);
    protected StateMachine<State> stateMachine;
    final Wallet wallet;
    protected final TransactionBroadcaster broadcaster;
    protected byte[] bestValueSignature;
    protected Coin bestValueToMe = Coin.ZERO;
    protected ECKey serverKey;
    protected long minExpireTime;
    protected StoredServerChannel storedServerChannel = null;
    protected Transaction contract = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PaymentChannelServerState(StoredServerChannel storedServerChannel, Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        StoredServerChannel storedServerChannel2 = storedServerChannel;
        synchronized (storedServerChannel2) {
            this.stateMachine = new StateMachine<State>(State.UNINITIALISED, this.getStateTransitions());
            this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
            this.broadcaster = (TransactionBroadcaster)Preconditions.checkNotNull((Object)broadcaster);
            this.contract = (Transaction)Preconditions.checkNotNull((Object)storedServerChannel.contract);
            this.serverKey = (ECKey)Preconditions.checkNotNull((Object)storedServerChannel.myKey);
            this.storedServerChannel = storedServerChannel;
            this.bestValueToMe = (Coin)Preconditions.checkNotNull((Object)storedServerChannel.bestValueToMe);
            this.minExpireTime = storedServerChannel.refundTransactionUnlockTimeSecs;
            this.bestValueSignature = storedServerChannel.bestValueSignature;
            Preconditions.checkArgument((this.bestValueToMe.equals(Coin.ZERO) || this.bestValueSignature != null ? 1 : 0) != 0);
            storedServerChannel.state = this;
        }
    }

    public PaymentChannelServerState(TransactionBroadcaster broadcaster, Wallet wallet, ECKey serverKey, long minExpireTime) {
        this.stateMachine = new StateMachine<State>(State.UNINITIALISED, this.getStateTransitions());
        this.serverKey = (ECKey)Preconditions.checkNotNull((Object)serverKey);
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.broadcaster = (TransactionBroadcaster)Preconditions.checkNotNull((Object)broadcaster);
        this.minExpireTime = minExpireTime;
    }

    public abstract int getMajorVersion();

    public synchronized State getState() {
        return this.stateMachine.getState();
    }

    protected abstract Multimap<State, State> getStateTransitions();

    public synchronized ListenableFuture<PaymentChannelServerState> provideContract(final Transaction contract) throws VerificationException {
        Preconditions.checkNotNull((Object)contract);
        this.stateMachine.checkState(State.WAITING_FOR_MULTISIG_CONTRACT);
        try {
            contract.verify();
            this.contract = contract;
            this.verifyContract(contract);
            Script expectedScript = this.createOutputScript();
            if (!Arrays.equals(this.getContractScript().getProgram(), expectedScript.getProgram())) {
                throw new VerificationException(this.getMajorVersion() == 1 ? "Contract's first output was not a standard 2-of-2 multisig to client and server in that order." : "Contract was not a P2SH script of a CLTV redeem script to client and server");
            }
            if (this.getTotalValue().signum() <= 0) {
                throw new VerificationException("Not accepting an attempt to open a contract with zero value.");
            }
        }
        catch (VerificationException e) {
            log.error("Provided multisig contract did not verify: {}", (Object)contract.toString());
            throw e;
        }
        log.info("Broadcasting multisig contract: {}", (Object)contract);
        this.wallet.addWatchedScripts((List<Script>)ImmutableList.of((Object)contract.getOutput(0L).getScriptPubKey()));
        this.stateMachine.transition(State.WAITING_FOR_MULTISIG_ACCEPTANCE);
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback(this.broadcaster.broadcastTransaction(contract).future(), (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction transaction) {
                log.info("Successfully broadcast multisig contract {}. Channel now open.", (Object)transaction.getHashAsString());
                try {
                    PaymentChannelServerState.this.wallet.receivePending(contract, null, true);
                }
                catch (VerificationException e) {
                    throw new RuntimeException(e);
                }
                PaymentChannelServerState.this.stateMachine.transition(State.READY);
                future.set((Object)PaymentChannelServerState.this);
            }

            public void onFailure(Throwable throwable) {
                log.error("Failed to broadcast contract", throwable);
                PaymentChannelServerState.this.stateMachine.transition(State.ERROR);
                future.setException(throwable);
            }
        });
        return future;
    }

    protected synchronized SendRequest makeUnsignedChannelContract(Coin valueToMe) {
        Transaction tx = new Transaction(this.wallet.getParams());
        if (!this.getTotalValue().subtract(valueToMe).equals(Coin.ZERO)) {
            tx.addOutput(this.getTotalValue().subtract(valueToMe), this.getClientKey().toAddress(this.wallet.getParams()));
        }
        tx.addInput(this.contract.getOutput(0L));
        return SendRequest.forTx(tx);
    }

    public synchronized boolean incrementPayment(Coin refundSize, byte[] signatureBytes) throws VerificationException, ValueOutOfRangeException, InsufficientMoneyException {
        this.stateMachine.checkState(State.READY);
        Preconditions.checkNotNull((Object)refundSize);
        Preconditions.checkNotNull((Object)signatureBytes);
        TransactionSignature signature = TransactionSignature.decodeFromBitcoin(signatureBytes, true);
        boolean fullyUsedUp = refundSize.equals(Coin.ZERO);
        Coin newValueToMe = this.getTotalValue().subtract(refundSize);
        if (newValueToMe.signum() < 0) {
            throw new ValueOutOfRangeException("Attempt to refund more than the contract allows.");
        }
        if (newValueToMe.compareTo(this.bestValueToMe) < 0) {
            throw new ValueOutOfRangeException("Attempt to roll back payment on the channel.");
        }
        SendRequest req = this.makeUnsignedChannelContract(newValueToMe);
        if (!fullyUsedUp && refundSize.isLessThan(req.tx.getOutput(0L).getMinNonDustValue())) {
            throw new ValueOutOfRangeException("Attempt to refund negative value or value too small to be accepted by the network");
        }
        Transaction walletContract = this.wallet.getTransaction(this.contract.getHash());
        Preconditions.checkNotNull((Object)walletContract, (String)"Wallet did not contain multisig contract {} after state was marked READY", (Object[])new Object[]{this.contract.getHash()});
        if (walletContract.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.DEAD) {
            this.close();
            throw new VerificationException("Multisig contract was double-spent");
        }
        Transaction.SigHash mode = fullyUsedUp ? Transaction.SigHash.NONE : Transaction.SigHash.SINGLE;
        if (signature.sigHashMode() != mode || !signature.anyoneCanPay()) {
            throw new VerificationException("New payment signature was not signed with the right SIGHASH flags.");
        }
        Sha256Hash sighash = req.tx.hashForSignature(0, this.getSignedScript(), mode, true);
        if (!this.getClientKey().verify(sighash, signature)) {
            throw new VerificationException("Signature does not verify on tx\n" + req.tx);
        }
        this.bestValueToMe = newValueToMe;
        this.bestValueSignature = signatureBytes;
        this.updateChannelInWallet();
        return !fullyUsedUp;
    }

    public abstract ListenableFuture<Transaction> close() throws InsufficientMoneyException;

    public synchronized Coin getBestValueToMe() {
        return this.bestValueToMe;
    }

    public abstract Coin getFeePaid();

    public synchronized Transaction getContract() {
        Preconditions.checkState((this.contract != null ? 1 : 0) != 0);
        return this.contract;
    }

    public long getExpiryTime() {
        return this.minExpireTime;
    }

    protected synchronized void updateChannelInWallet() {
        if (this.storedServerChannel != null) {
            this.storedServerChannel.updateValueToMe(this.bestValueToMe, this.bestValueSignature);
            StoredPaymentChannelServerStates channels = (StoredPaymentChannelServerStates)this.wallet.getExtensions().get(StoredPaymentChannelServerStates.EXTENSION_ID);
            channels.updatedChannel(this.storedServerChannel);
        }
    }

    public synchronized void storeChannelInWallet(@Nullable PaymentChannelServer connectedHandler) {
        this.stateMachine.checkState(State.READY);
        if (this.storedServerChannel != null) {
            return;
        }
        log.info("Storing state with contract hash {}.", (Object)this.getContract().getHash());
        StoredPaymentChannelServerStates channels = (StoredPaymentChannelServerStates)this.wallet.addOrGetExistingExtension(new StoredPaymentChannelServerStates(this.wallet, this.broadcaster));
        this.storedServerChannel = new StoredServerChannel(this, this.getMajorVersion(), this.getContract(), this.getClientOutput(), this.getExpiryTime(), this.serverKey, this.getClientKey(), this.bestValueToMe, this.bestValueSignature);
        if (connectedHandler != null) {
            Preconditions.checkState((this.storedServerChannel.setConnectedHandler(connectedHandler, false) == connectedHandler ? 1 : 0) != 0);
        }
        channels.putChannel(this.storedServerChannel);
    }

    public abstract TransactionOutput getClientOutput();

    public Script getContractScript() {
        if (this.contract == null) {
            return null;
        }
        return this.contract.getOutput(0L).getScriptPubKey();
    }

    protected abstract Script getSignedScript();

    protected void verifyContract(Transaction contract) {
    }

    protected abstract Script createOutputScript();

    protected Coin getTotalValue() {
        return this.contract.getOutput(0L).getValue();
    }

    protected abstract ECKey getClientKey();

    public static enum State {
        UNINITIALISED,
        WAITING_FOR_REFUND_TRANSACTION,
        WAITING_FOR_MULTISIG_CONTRACT,
        WAITING_FOR_MULTISIG_ACCEPTANCE,
        READY,
        CLOSING,
        CLOSED,
        ERROR;

    }
}

