/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.crypto;

import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.encoders.Encoder;

@Deprecated
public class Hash {
    private static final int KEY_LEN = 64;
    private static final int SALTBYTES = 32;
    private byte[] buffer;

    public byte[] sha256(byte[] message) {
        this.buffer = new byte[32];
        NaCl.sodium();
        Sodium.crypto_hash_sha256(this.buffer, message, message.length);
        return this.buffer;
    }

    public byte[] sha512(byte[] message) {
        this.buffer = new byte[64];
        NaCl.sodium();
        Sodium.crypto_hash_sha512(this.buffer, message, message.length);
        return this.buffer;
    }

    public String sha256(String message, Encoder encoder) {
        byte[] hash = this.sha256(message.getBytes());
        return encoder.encode(hash);
    }

    public String sha512(String message, Encoder encoder) {
        byte[] hash = this.sha512(message.getBytes());
        return encoder.encode(hash);
    }

    public String pwhash_scryptsalsa208sha256(String passwd, Encoder encoder, byte[] salt, int opslimit, int memlimit) {
        this.buffer = new byte[64];
        NaCl.sodium();
        Sodium.crypto_pwhash_scryptsalsa208sha256(this.buffer, this.buffer.length, passwd.getBytes(), passwd.length(), salt, opslimit, memlimit);
        return encoder.encode(this.buffer);
    }

    public byte[] blake2(byte[] message) throws UnsupportedOperationException {
        if (!this.blakeSupportedVersion()) {
            throw new UnsupportedOperationException();
        }
        this.buffer = new byte[64];
        NaCl.sodium();
        Sodium.crypto_generichash_blake2b(this.buffer, 64, message, message.length, new byte[0], 0);
        return this.buffer;
    }

    public String blake2(String message, Encoder encoder) throws UnsupportedOperationException {
        if (!this.blakeSupportedVersion()) {
            throw new UnsupportedOperationException();
        }
        byte[] hash = this.blake2(message.getBytes());
        return encoder.encode(hash);
    }

    private boolean blakeSupportedVersion() {
        String sodiumversion = new String("0.4.1");
        return sodiumversion.compareTo("0.4.0") >= 0;
    }
}

