/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.TorParsingException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPv4Address {
    private final int addressData;

    public static IPv4Address createFromString(String addressString) {
        return new IPv4Address(IPv4Address.parseStringToAddressData(addressString));
    }

    private static int parseStringToAddressData(String ipString) {
        String[] octets = ipString.split("\\.");
        int[] shifts = new int[]{24, 16, 8, 0};
        int addressData = 0;
        int i = 0;
        for (String o : octets) {
            addressData |= IPv4Address.octetStringToInt(o) << shifts[i++];
        }
        return addressData;
    }

    private static int octetStringToInt(String octet) {
        try {
            int result = Integer.parseInt(octet);
            if (result < 0 || result > 255) {
                throw new TorParsingException("Octet out of range: " + octet);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new TorParsingException("Failed to parse octet: " + octet);
        }
    }

    public static boolean isValidIPv4AddressString(String addressString) {
        try {
            IPv4Address.createFromString(addressString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IPv4Address(int addressData) {
        this.addressData = addressData;
    }

    public int getAddressData() {
        return this.addressData;
    }

    public byte[] getAddressDataBytes() {
        byte[] result = new byte[]{(byte)(this.addressData >> 24 & 0xFF), (byte)(this.addressData >> 16 & 0xFF), (byte)(this.addressData >> 8 & 0xFF), (byte)(this.addressData & 0xFF)};
        return result;
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByAddress(this.getAddressDataBytes());
        }
        catch (UnknownHostException e) {
            throw new TorException(e);
        }
    }

    public static String stringFormat(int addressData) {
        return (addressData >> 24 & 0xFF) + "." + (addressData >> 16 & 0xFF) + "." + (addressData >> 8 & 0xFF) + "." + (addressData & 0xFF);
    }

    public String toString() {
        return IPv4Address.stringFormat(this.addressData);
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (!(ob instanceof IPv4Address)) {
            return false;
        }
        IPv4Address other = (IPv4Address)ob;
        return other.addressData == this.addressData;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 4;
            n ^= this.addressData >> i * 8 & 0xFF;
        }
        return n;
    }
}

