/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.crypto.TorRandom;

public class CircuitStatus {
    private long timestampCreated;
    private long timestampDirty;
    private int currentStreamId;
    private Object streamIdLock = new Object();
    private volatile CircuitState state = CircuitState.UNCONNECTED;

    CircuitStatus() {
        this.initializeCurrentStreamId();
    }

    private void initializeCurrentStreamId() {
        TorRandom random = new TorRandom();
        this.currentStreamId = random.nextInt(65535) + 1;
    }

    synchronized void updateCreatedTimestamp() {
        this.timestampCreated = System.currentTimeMillis();
        this.timestampDirty = 0L;
    }

    synchronized void updateDirtyTimestamp() {
        if (this.timestampDirty == 0L && this.state != CircuitState.BUILDING) {
            this.timestampDirty = System.currentTimeMillis();
        }
    }

    synchronized long getMillisecondsElapsedSinceCreated() {
        return CircuitStatus.millisecondsElapsedSince(this.timestampCreated);
    }

    synchronized long getMillisecondsDirty() {
        return CircuitStatus.millisecondsElapsedSince(this.timestampDirty);
    }

    private static long millisecondsElapsedSince(long then) {
        if (then == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        return now - then;
    }

    synchronized boolean isDirty() {
        return this.timestampDirty != 0L;
    }

    void setStateBuilding() {
        this.state = CircuitState.BUILDING;
    }

    void setStateFailed() {
        this.state = CircuitState.FAILED;
    }

    void setStateOpen() {
        this.state = CircuitState.OPEN;
    }

    void setStateDestroyed() {
        this.state = CircuitState.DESTROYED;
    }

    boolean isBuilding() {
        return this.state == CircuitState.BUILDING;
    }

    boolean isConnected() {
        return this.state == CircuitState.OPEN;
    }

    boolean isUnconnected() {
        return this.state == CircuitState.UNCONNECTED;
    }

    String getStateAsString() {
        if (this.state == CircuitState.OPEN) {
            return this.state.toString() + " [" + this.getDirtyString() + "]";
        }
        return this.state.toString();
    }

    private String getDirtyString() {
        if (!this.isDirty()) {
            return "Clean";
        }
        return "Dirty " + this.getMillisecondsDirty() / 1000L + "s";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int nextStreamId() {
        Object object = this.streamIdLock;
        synchronized (object) {
            ++this.currentStreamId;
            if (this.currentStreamId > 65535) {
                this.currentStreamId = 1;
            }
            return this.currentStreamId;
        }
    }

    static enum CircuitState {
        UNCONNECTED("Unconnected"),
        BUILDING("Building"),
        FAILED("Failed"),
        OPEN("Open"),
        DESTROYED("Destroyed");

        String name;

        private CircuitState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

