/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitImpl;
import com.subgraph.orchid.circuits.CircuitNodeImpl;
import com.subgraph.orchid.circuits.NTorCircuitExtender;
import com.subgraph.orchid.circuits.TapCircuitExtender;
import com.subgraph.orchid.circuits.cells.CellImpl;
import com.subgraph.orchid.circuits.cells.RelayCellImpl;
import com.subgraph.orchid.crypto.TorCreateFastKeyAgreement;
import com.subgraph.orchid.crypto.TorKeyAgreement;
import java.util.logging.Logger;

public class CircuitExtender {
    private static final Logger logger = Logger.getLogger(CircuitExtender.class.getName());
    private static final int DH_BYTES = 128;
    private static final int PKCS1_OAEP_PADDING_OVERHEAD = 42;
    private static final int CIPHER_KEY_LEN = 16;
    static final int TAP_ONIONSKIN_LEN = 186;
    static final int TAP_ONIONSKIN_REPLY_LEN = 148;
    private final CircuitImpl circuit;
    private final boolean ntorEnabled;

    CircuitExtender(CircuitImpl circuit, boolean ntorEnabled) {
        this.circuit = circuit;
        this.ntorEnabled = ntorEnabled;
    }

    CircuitNode createFastTo(Router targetRouter) {
        logger.fine("Creating 'fast' to " + targetRouter);
        TorCreateFastKeyAgreement kex = new TorCreateFastKeyAgreement();
        this.sendCreateFastCell(kex);
        return this.receiveAndProcessCreateFastResponse(targetRouter, kex);
    }

    private void sendCreateFastCell(TorCreateFastKeyAgreement kex) {
        CellImpl cell = CellImpl.createCell(this.circuit.getCircuitId(), 5);
        cell.putByteArray(kex.createOnionSkin());
        this.circuit.sendCell(cell);
    }

    private CircuitNode receiveAndProcessCreateFastResponse(Router targetRouter, TorKeyAgreement kex) {
        Cell cell = this.circuit.receiveControlCellResponse();
        if (cell == null) {
            throw new TorException("Timeout building circuit waiting for CREATE_FAST response from " + targetRouter);
        }
        return this.processCreatedFastCell(targetRouter, cell, kex);
    }

    private CircuitNode processCreatedFastCell(Router targetRouter, Cell cell, TorKeyAgreement kex) {
        byte[] payload = new byte[40];
        byte[] keyMaterial = new byte[72];
        byte[] verifyHash = new byte[20];
        cell.getByteArray(payload);
        if (!kex.deriveKeysFromHandshakeResponse(payload, keyMaterial, verifyHash)) {
            return null;
        }
        CircuitNode node = CircuitNodeImpl.createFirstHop(targetRouter, keyMaterial, verifyHash);
        this.circuit.appendNode(node);
        return node;
    }

    CircuitNode extendTo(Router targetRouter) {
        if (this.circuit.getCircuitLength() == 0) {
            throw new TorException("Cannot EXTEND an empty circuit");
        }
        if (this.useNtor(targetRouter)) {
            NTorCircuitExtender nce = new NTorCircuitExtender(this, targetRouter);
            return nce.extendTo();
        }
        TapCircuitExtender tce = new TapCircuitExtender(this, targetRouter);
        return tce.extendTo();
    }

    private boolean useNtor(Router targetRouter) {
        return this.ntorEnabled && targetRouter.getNTorOnionKey() != null;
    }

    private void logProtocolViolation(String sourceName, Router targetRouter) {
        String version = targetRouter == null ? "(none)" : targetRouter.getVersion();
        String targetName = targetRouter == null ? "(none)" : targetRouter.getNickname();
        logger.warning("Protocol error extending circuit from (" + sourceName + ") to (" + targetName + ") [version: " + version + "]");
    }

    private String nodeToName(CircuitNode node) {
        if (node == null || node.getRouter() == null) {
            return "(null)";
        }
        Router router = node.getRouter();
        return router.getNickname();
    }

    public void sendRelayCell(RelayCell cell) {
        this.circuit.sendRelayCell(cell);
    }

    public RelayCell receiveRelayResponse(int expectedCommand, Router extendTarget) {
        RelayCell cell = this.circuit.receiveRelayCell();
        if (cell == null) {
            throw new TorException("Timeout building circuit");
        }
        int command = cell.getRelayCommand();
        if (command == 9) {
            int code = cell.getByte() & 0xFF;
            String msg = CellImpl.errorToDescription(code);
            String source = this.nodeToName(cell.getCircuitNode());
            if (code == 1) {
                this.logProtocolViolation(source, extendTarget);
            }
            throw new TorException("Error from (" + source + ") while extending to (" + extendTarget.getNickname() + "): " + msg);
        }
        if (command != expectedCommand) {
            String expected = RelayCellImpl.commandToDescription(expectedCommand);
            String received = RelayCellImpl.commandToDescription(command);
            throw new TorException("Received incorrect extend response, expecting " + expected + " but received " + received);
        }
        return cell;
    }

    public CircuitNode createNewNode(Router r, byte[] keyMaterial, byte[] verifyDigest) {
        CircuitNode node = CircuitNodeImpl.createNode(r, this.circuit.getFinalCircuitNode(), keyMaterial, verifyDigest);
        logger.fine("Adding new circuit node for " + r.getNickname());
        this.circuit.appendNode(node);
        return node;
    }

    public RelayCell createRelayCell(int command) {
        return new RelayCellImpl(this.circuit.getFinalCircuitNode(), this.circuit.getCircuitId(), 0, command, true);
    }

    Router getFinalRouter() {
        CircuitNode node = this.circuit.getFinalCircuitNode();
        if (node != null) {
            return node.getRouter();
        }
        return null;
    }
}

