/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.helper;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha256Hash {
    public static final int LENGTH = 32;

    public static MessageDigest newDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] hash(byte[] input) {
        return Sha256Hash.hash(input, 0, input.length);
    }

    public static byte[] hash(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest();
    }

    public static byte[] hashTwiceThenFirstFourOnly(byte[] input) {
        byte[] firstFourOfDoubleChecksum = new byte[4];
        byte[] sha256DoubleHash = Sha256Hash.hashTwice(input);
        System.arraycopy(sha256DoubleHash, 0, firstFourOfDoubleChecksum, 0, 4);
        return firstFourOfDoubleChecksum;
    }

    public static byte[] hashTwiceTezos(byte[] input, int len) {
        byte[] tezosAddress = new byte[20];
        byte[] sha256DoubleHash = Sha256Hash.hashTwice(input);
        System.arraycopy(sha256DoubleHash, 0, tezosAddress, 0, 19);
        return tezosAddress;
    }

    public static byte[] hashTwice(byte[] input) {
        return Sha256Hash.hashTwice(input, 0, input.length);
    }

    public static byte[] hashTwice(byte[] input, int offset, int length) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input, offset, length);
        return digest.digest(digest.digest());
    }

    public static byte[] hashTwice(byte[] input1, int offset1, int length1, byte[] input2, int offset2, int length2) {
        MessageDigest digest = Sha256Hash.newDigest();
        digest.update(input1, offset1, length1);
        digest.update(input2, offset2, length2);
        return digest.digest(digest.digest());
    }
}

