/*
 * Decompiled with CFR 0.152.
 */
package org.libsodium.jni.keys;

import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;

public class PrivateKey {
    private final byte[] secretKey;

    public PrivateKey(byte[] secretKey) {
        this.secretKey = secretKey;
        Util.checkLength(secretKey, 32);
    }

    public PrivateKey(String secretKey) {
        this.secretKey = Encoder.HEX.decode(secretKey);
        Util.checkLength(this.secretKey, 32);
    }

    public byte[] toBytes() {
        return this.secretKey;
    }

    public String toString() {
        return Encoder.HEX.encode(this.secretKey);
    }
}

