/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid;

import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryStore;
import com.subgraph.orchid.Revision;
import com.subgraph.orchid.SocksPortListener;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.config.TorConfigProxy;
import com.subgraph.orchid.connections.ConnectionCacheImpl;
import com.subgraph.orchid.directory.DirectoryImpl;
import com.subgraph.orchid.directory.downloader.DirectoryDownloaderImpl;
import com.subgraph.orchid.socks.SocksPortListenerImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public class Tor {
    private static final Logger logger = Logger.getLogger(Tor.class.getName());
    public static final int BOOTSTRAP_STATUS_STARTING = 0;
    public static final int BOOTSTRAP_STATUS_CONN_DIR = 5;
    public static final int BOOTSTRAP_STATUS_HANDSHAKE_DIR = 10;
    public static final int BOOTSTRAP_STATUS_ONEHOP_CREATE = 15;
    public static final int BOOTSTRAP_STATUS_REQUESTING_STATUS = 20;
    public static final int BOOTSTRAP_STATUS_LOADING_STATUS = 25;
    public static final int BOOTSTRAP_STATUS_REQUESTING_KEYS = 35;
    public static final int BOOTSTRAP_STATUS_LOADING_KEYS = 40;
    public static final int BOOTSTRAP_STATUS_REQUESTING_DESCRIPTORS = 45;
    public static final int BOOTSTRAP_STATUS_LOADING_DESCRIPTORS = 50;
    public static final int BOOTSTRAP_STATUS_CONN_OR = 80;
    public static final int BOOTSTRAP_STATUS_HANDSHAKE_OR = 85;
    public static final int BOOTSTRAP_STATUS_CIRCUIT_CREATE = 90;
    public static final int BOOTSTRAP_STATUS_DONE = 100;
    private static final String implementation = "Orchid";
    private static final String version = "1.0.0";
    private static final Charset defaultCharset = Tor.createDefaultCharset();

    private static Charset createDefaultCharset() {
        return Charset.forName("ISO-8859-1");
    }

    public static Charset getDefaultCharset() {
        return defaultCharset;
    }

    public static String getBuildRevision() {
        return Revision.getBuildRevision();
    }

    public static String getImplementation() {
        return implementation;
    }

    public static String getFullVersion() {
        String revision = Tor.getBuildRevision();
        if (revision == null || revision.isEmpty()) {
            return Tor.getVersion();
        }
        return Tor.getVersion() + "." + revision;
    }

    public static String getVersion() {
        return version;
    }

    public static boolean isAndroidRuntime() {
        String runtime = System.getProperty("java.runtime.name");
        return runtime != null && runtime.equals("Android Runtime");
    }

    public static TorConfig createConfig() {
        TorConfig config = (TorConfig)Proxy.newProxyInstance(TorConfigProxy.class.getClassLoader(), new Class[]{TorConfig.class}, (InvocationHandler)new TorConfigProxy());
        if (Tor.isAndroidRuntime()) {
            logger.warning("Android Runtime detected, disabling V2 Link protocol");
            config.setHandshakeV2Enabled(false);
        }
        return config;
    }

    public static TorInitializationTracker createInitalizationTracker() {
        return new TorInitializationTracker();
    }

    public static Directory createDirectory(TorConfig config, DirectoryStore customDirectoryStore) {
        return new DirectoryImpl(config, customDirectoryStore);
    }

    public static ConnectionCache createConnectionCache(TorConfig config, TorInitializationTracker tracker) {
        return new ConnectionCacheImpl(config, tracker);
    }

    public static CircuitManager createCircuitManager(TorConfig config, DirectoryDownloaderImpl directoryDownloader, Directory directory, ConnectionCache connectionCache, TorInitializationTracker tracker) {
        return new CircuitManagerImpl(config, directoryDownloader, directory, connectionCache, tracker);
    }

    public static SocksPortListener createSocksPortListener(TorConfig config, CircuitManager circuitManager) {
        return new SocksPortListenerImpl(config, circuitManager);
    }

    public static DirectoryDownloaderImpl createDirectoryDownloader(TorConfig config, TorInitializationTracker initializationTracker) {
        return new DirectoryDownloaderImpl(config, initializationTracker);
    }
}

