/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.directory.downloader.DocumentFetcher;
import com.subgraph.orchid.directory.parsing.DocumentParser;
import java.nio.ByteBuffer;
import java.util.Set;

public class CertificateFetcher
extends DocumentFetcher<KeyCertificate> {
    private final Set<ConsensusDocument.RequiredCertificate> requiredCertificates;

    public CertificateFetcher(Set<ConsensusDocument.RequiredCertificate> requiredCertificates) {
        this.requiredCertificates = requiredCertificates;
    }

    @Override
    String getRequestPath() {
        return "/tor/keys/fp-sk/" + this.getRequiredCertificatesRequestString();
    }

    private String getRequiredCertificatesRequestString() {
        StringBuilder sb = new StringBuilder();
        for (ConsensusDocument.RequiredCertificate rc : this.requiredCertificates) {
            if (sb.length() > 0) {
                sb.append("+");
            }
            sb.append(rc.getAuthorityIdentity().toString());
            sb.append("-");
            sb.append(rc.getSigningKey().toString());
        }
        return sb.toString();
    }

    @Override
    DocumentParser<KeyCertificate> createParser(ByteBuffer response) {
        return PARSER_FACTORY.createKeyCertificateParser(response);
    }
}

