/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.Circuit;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.Connection;
import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.ExitCircuit;
import com.subgraph.orchid.InternalCircuit;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitIO;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.CircuitStatus;
import com.subgraph.orchid.circuits.DirectoryCircuitImpl;
import com.subgraph.orchid.circuits.ExitCircuitImpl;
import com.subgraph.orchid.circuits.InternalCircuitImpl;
import com.subgraph.orchid.circuits.StreamImpl;
import com.subgraph.orchid.circuits.path.CircuitPathChooser;
import com.subgraph.orchid.circuits.path.PathSelectionFailedException;
import com.subgraph.orchid.dashboard.DashboardRenderable;
import com.subgraph.orchid.dashboard.DashboardRenderer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public abstract class CircuitImpl
implements Circuit,
DashboardRenderable {
    protected static final Logger logger = Logger.getLogger(CircuitImpl.class.getName());
    private final CircuitManagerImpl circuitManager;
    protected final List<Router> prechosenPath;
    private final List<CircuitNode> nodeList = new ArrayList<CircuitNode>();
    private final CircuitStatus status;
    private CircuitIO io;

    static ExitCircuit createExitCircuit(CircuitManagerImpl circuitManager, Router exitRouter) {
        return new ExitCircuitImpl(circuitManager, exitRouter);
    }

    static ExitCircuit createExitCircuitTo(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        return new ExitCircuitImpl(circuitManager, prechosenPath);
    }

    static DirectoryCircuit createDirectoryCircuit(CircuitManagerImpl circuitManager) {
        return new DirectoryCircuitImpl(circuitManager, null);
    }

    static DirectoryCircuit createDirectoryCircuitTo(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        return new DirectoryCircuitImpl(circuitManager, prechosenPath);
    }

    static InternalCircuit createInternalCircuitTo(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        return new InternalCircuitImpl(circuitManager, prechosenPath);
    }

    protected CircuitImpl(CircuitManagerImpl circuitManager) {
        this(circuitManager, null);
    }

    protected CircuitImpl(CircuitManagerImpl circuitManager, List<Router> prechosenPath) {
        this.circuitManager = circuitManager;
        this.prechosenPath = prechosenPath;
        this.status = new CircuitStatus();
    }

    List<Router> choosePath(CircuitPathChooser pathChooser) throws InterruptedException, PathSelectionFailedException {
        if (this.prechosenPath != null) {
            return new ArrayList<Router>(this.prechosenPath);
        }
        return this.choosePathForCircuit(pathChooser);
    }

    protected abstract List<Router> choosePathForCircuit(CircuitPathChooser var1) throws InterruptedException, PathSelectionFailedException;

    void bindToConnection(Connection connection) {
        if (this.io != null) {
            throw new IllegalStateException("Circuit already bound to a connection");
        }
        int id = connection.bindCircuit(this);
        this.io = new CircuitIO(this, connection, id);
    }

    @Override
    public void markForClose() {
        if (this.io != null) {
            this.io.markForClose();
        }
    }

    @Override
    public boolean isMarkedForClose() {
        if (this.io == null) {
            return false;
        }
        return this.io.isMarkedForClose();
    }

    CircuitStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isConnected() {
        return this.status.isConnected();
    }

    @Override
    public boolean isPending() {
        return this.status.isBuilding();
    }

    @Override
    public boolean isClean() {
        return !this.status.isDirty();
    }

    @Override
    public int getSecondsDirty() {
        return (int)(this.status.getMillisecondsDirty() / 1000L);
    }

    void notifyCircuitBuildStart() {
        if (!this.status.isUnconnected()) {
            throw new IllegalStateException("Can only connect UNCONNECTED circuits");
        }
        this.status.updateCreatedTimestamp();
        this.status.setStateBuilding();
        this.circuitManager.addActiveCircuit(this);
    }

    void notifyCircuitBuildFailed() {
        this.status.setStateFailed();
        this.circuitManager.removeActiveCircuit(this);
    }

    void notifyCircuitBuildCompleted() {
        this.status.setStateOpen();
        this.status.updateCreatedTimestamp();
    }

    @Override
    public Connection getConnection() {
        if (!this.isConnected()) {
            throw new TorException("Circuit is not connected.");
        }
        return this.io.getConnection();
    }

    @Override
    public int getCircuitId() {
        if (this.io == null) {
            return 0;
        }
        return this.io.getCircuitId();
    }

    @Override
    public void sendRelayCell(RelayCell cell) {
        this.io.sendRelayCellTo(cell, cell.getCircuitNode());
    }

    public void sendRelayCellToFinalNode(RelayCell cell) {
        this.io.sendRelayCellTo(cell, this.getFinalCircuitNode());
    }

    @Override
    public void appendNode(CircuitNode node) {
        this.nodeList.add(node);
    }

    List<CircuitNode> getNodeList() {
        return this.nodeList;
    }

    int getCircuitLength() {
        return this.nodeList.size();
    }

    @Override
    public CircuitNode getFinalCircuitNode() {
        if (this.nodeList.isEmpty()) {
            throw new TorException("getFinalCircuitNode() called on empty circuit");
        }
        return this.nodeList.get(this.getCircuitLength() - 1);
    }

    @Override
    public RelayCell createRelayCell(int relayCommand, int streamId, CircuitNode targetNode) {
        return this.io.createRelayCell(relayCommand, streamId, targetNode);
    }

    @Override
    public RelayCell receiveRelayCell() {
        return this.io.dequeueRelayResponseCell();
    }

    void sendCell(Cell cell) {
        this.io.sendCell(cell);
    }

    Cell receiveControlCellResponse() {
        return this.io.receiveControlCellResponse();
    }

    @Override
    public void deliverControlCell(Cell cell) {
        this.io.deliverControlCell(cell);
    }

    @Override
    public void deliverRelayCell(Cell cell) {
        this.io.deliverRelayCell(cell);
    }

    protected StreamImpl createNewStream(boolean autoclose) {
        return this.io.createNewStream(autoclose);
    }

    protected StreamImpl createNewStream() {
        return this.createNewStream(false);
    }

    void setStateDestroyed() {
        this.status.setStateDestroyed();
        this.circuitManager.removeActiveCircuit(this);
    }

    @Override
    public void destroyCircuit() {
        if (this.io != null) {
            this.io.destroyCircuit();
        }
        this.circuitManager.removeActiveCircuit(this);
    }

    public void removeStream(StreamImpl stream) {
        this.io.removeStream(stream);
    }

    protected Stream processStreamOpenException(Exception e) throws InterruptedException, TimeoutException, StreamConnectFailedException {
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof TimeoutException) {
            throw (TimeoutException)e;
        }
        if (e instanceof StreamConnectFailedException) {
            throw (StreamConnectFailedException)e;
        }
        throw new IllegalStateException();
    }

    protected abstract String getCircuitTypeLabel();

    public String toString() {
        return "  Circuit (" + this.getCircuitTypeLabel() + ") id=" + this.getCircuitId() + " state=" + this.status.getStateAsString() + " " + this.pathToString();
    }

    protected String pathToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (CircuitNode node : this.nodeList) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(node.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<Stream> getActiveStreams() {
        if (this.io == null) {
            return Collections.emptyList();
        }
        return this.io.getActiveStreams();
    }

    @Override
    public void dashboardRender(DashboardRenderer renderer, PrintWriter writer, int flags) throws IOException {
        if (this.io != null) {
            writer.println(this.toString());
            renderer.renderComponent(writer, flags, this.io);
        }
    }
}

