/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.helper;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;

public class Base58Check {
    private static String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static char[] ALPHABET_ARRAY = ALPHABET.toCharArray();
    private static BigInteger BASE_SIZE = BigInteger.valueOf(ALPHABET_ARRAY.length);
    private static int CHECKSUM_SIZE = 4;

    public static String encode(byte[] data) throws NoSuchAlgorithmException {
        return Base58Check.encodePlain(Base58Check.addChecksum(data));
    }

    public static String encodePlain(byte[] data) {
        BigInteger intData;
        try {
            intData = new BigInteger(1, data);
        }
        catch (NumberFormatException e) {
            return "";
        }
        String result = "";
        while (intData.compareTo(BigInteger.ZERO) == 1) {
            BigInteger[] quotientAndRemainder = intData.divideAndRemainder(BASE_SIZE);
            BigInteger quotient = quotientAndRemainder[0];
            BigInteger remainder = quotientAndRemainder[1];
            intData = quotient;
            result = ALPHABET_ARRAY[remainder.intValue()] + result;
        }
        for (int i = 0; i < data.length && data[i] == 0; ++i) {
            result = '1' + result;
        }
        return result;
    }

    public static byte[] decode(String encoded) throws NoSuchAlgorithmException {
        byte[] valueWithChecksum = Base58Check.decodePlain(encoded);
        byte[] value = Base58Check.verifyAndRemoveChecksum(valueWithChecksum);
        if (value == null) {
            throw new IllegalArgumentException("Base58 checksum is invalid");
        }
        return value;
    }

    public static byte[] decodePlain(String encoded) {
        char current;
        int i;
        if (encoded.length() == 0) {
            return new byte[0];
        }
        BigInteger intData = BigInteger.ZERO;
        int leadingZeros = 0;
        for (i = 0; i < encoded.length(); ++i) {
            current = encoded.charAt(i);
            int digit = ALPHABET.indexOf(current);
            if (digit == -1) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid Base58 character `%c` at position %d", Character.valueOf(current), i));
            }
            intData = intData.multiply(BASE_SIZE).add(BigInteger.valueOf(digit));
        }
        for (i = 0; i < encoded.length() && (current = encoded.charAt(i)) == '1'; ++i) {
            ++leadingZeros;
        }
        byte[] bytesData = intData.equals(BigInteger.ZERO) ? new byte[]{} : intData.toByteArray();
        boolean stripSignByte = bytesData.length > 1 && bytesData[0] == 0 && bytesData[1] < 0;
        byte[] decoded = new byte[bytesData.length - (stripSignByte ? 1 : 0) + leadingZeros];
        System.arraycopy(bytesData, stripSignByte ? 1 : 0, decoded, leadingZeros, decoded.length - leadingZeros);
        return decoded;
    }

    private static byte[] verifyAndRemoveChecksum(byte[] data) throws NoSuchAlgorithmException {
        byte[] expectedChecksum;
        byte[] value = Arrays.copyOfRange(data, 0, data.length - CHECKSUM_SIZE);
        byte[] checksum = Arrays.copyOfRange(data, data.length - CHECKSUM_SIZE, data.length);
        return (byte[])(Arrays.equals(checksum, expectedChecksum = Base58Check.getChecksum(value)) ? value : null);
    }

    private static byte[] addChecksum(byte[] data) throws NoSuchAlgorithmException {
        byte[] checksum = Base58Check.getChecksum(data);
        byte[] result = new byte[data.length + checksum.length];
        System.arraycopy(data, 0, result, 0, data.length);
        System.arraycopy(checksum, 0, result, data.length, checksum.length);
        return result;
    }

    private static byte[] getChecksum(byte[] data) throws NoSuchAlgorithmException {
        byte[] hash = Base58Check.hash256(data);
        hash = Base58Check.hash256(hash);
        return Arrays.copyOfRange(hash, 0, CHECKSUM_SIZE);
    }

    public static byte[] hash256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(data);
        return md.digest();
    }
}

