/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.consensus;

import com.subgraph.orchid.directory.consensus.ConsensusDocumentImpl;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentParser;
import com.subgraph.orchid.directory.consensus.ConsensusDocumentSectionParser;
import com.subgraph.orchid.directory.consensus.DocumentKeyword;
import com.subgraph.orchid.directory.consensus.VoteAuthorityEntryImpl;
import com.subgraph.orchid.directory.parsing.DocumentFieldParser;

public class AuthoritySectionParser
extends ConsensusDocumentSectionParser {
    private VoteAuthorityEntryImpl currentEntry = null;

    AuthoritySectionParser(DocumentFieldParser parser, ConsensusDocumentImpl document) {
        super(parser, document);
        this.startEntry();
    }

    @Override
    void parseLine(DocumentKeyword keyword) {
        switch (keyword) {
            case DIR_SOURCE: {
                this.parseDirSource();
                break;
            }
            case CONTACT: {
                this.currentEntry.setContact(this.fieldParser.parseConcatenatedString());
                break;
            }
            case VOTE_DIGEST: {
                this.currentEntry.setVoteDigest(this.fieldParser.parseHexDigest());
                this.addCurrentEntry();
                break;
            }
        }
    }

    private void startEntry() {
        this.currentEntry = new VoteAuthorityEntryImpl();
    }

    private void addCurrentEntry() {
        this.document.addVoteAuthorityEntry(this.currentEntry);
        this.startEntry();
    }

    private void parseDirSource() {
        this.currentEntry.setNickname(this.fieldParser.parseNickname());
        this.currentEntry.setIdentity(this.fieldParser.parseHexDigest());
        this.currentEntry.setHostname(this.fieldParser.parseString());
        this.currentEntry.setAddress(this.fieldParser.parseAddress());
        this.currentEntry.setDirectoryPort(this.fieldParser.parsePort());
        this.currentEntry.setRouterPort(this.fieldParser.parsePort());
    }

    @Override
    String getNextStateKeyword() {
        return "r";
    }

    @Override
    ConsensusDocumentParser.DocumentSection getSection() {
        return ConsensusDocumentParser.DocumentSection.AUTHORITY;
    }

    @Override
    ConsensusDocumentParser.DocumentSection nextSection() {
        return ConsensusDocumentParser.DocumentSection.ROUTER_STATUS;
    }
}

