/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.cells;

import com.subgraph.orchid.Cell;
import com.subgraph.orchid.CircuitNode;
import com.subgraph.orchid.RelayCell;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.cells.CellImpl;
import java.nio.ByteBuffer;

public class RelayCellImpl
extends CellImpl
implements RelayCell {
    private final int streamId;
    private final int relayCommand;
    private final CircuitNode circuitNode;
    private final boolean isOutgoing;

    public static RelayCell createFromCell(CircuitNode node, Cell cell) {
        if (cell.getCommand() != 3) {
            throw new TorException("Attempted to create RelayCell from Cell type: " + cell.getCommand());
        }
        return new RelayCellImpl(node, cell.getCellBytes());
    }

    public RelayCellImpl(CircuitNode node, int circuit, int stream, int relayCommand) {
        this(node, circuit, stream, relayCommand, false);
    }

    public RelayCellImpl(CircuitNode node, int circuit, int stream, int relayCommand, boolean isRelayEarly) {
        super(circuit, isRelayEarly ? 9 : 3);
        this.circuitNode = node;
        this.relayCommand = relayCommand;
        this.streamId = stream;
        this.isOutgoing = true;
        this.putByte(relayCommand);
        this.putShort(0);
        this.putShort(stream);
        this.putInt(0);
        this.putShort(0);
    }

    private RelayCellImpl(CircuitNode node, byte[] rawCell) {
        super(rawCell);
        this.circuitNode = node;
        this.relayCommand = this.getByte();
        this.getShort();
        this.streamId = this.getShort();
        this.isOutgoing = false;
        this.getInt();
        int payloadLength = this.getShort();
        this.cellBuffer.mark();
        if (14 + payloadLength > rawCell.length) {
            throw new TorException("Header length field exceeds total size of cell");
        }
        this.cellBuffer.limit(14 + payloadLength);
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public int getRelayCommand() {
        return this.relayCommand;
    }

    @Override
    public void setLength() {
        this.putShortAt(12, (short)(this.cellBytesConsumed() - 14));
    }

    @Override
    public void setDigest(byte[] digest) {
        for (int i = 0; i < 4; ++i) {
            this.putByteAt(8 + i, digest[i]);
        }
    }

    @Override
    public ByteBuffer getPayloadBuffer() {
        ByteBuffer dup = this.cellBuffer.duplicate();
        dup.reset();
        return dup.slice();
    }

    @Override
    public CircuitNode getCircuitNode() {
        return this.circuitNode;
    }

    @Override
    public String toString() {
        if (this.isOutgoing) {
            return "[" + RelayCellImpl.commandToDescription(this.relayCommand) + " stream=" + this.streamId + " payload_len=" + (this.cellBytesConsumed() - 14) + " dest=" + this.circuitNode + "]";
        }
        return "[" + this.commandToString() + " stream=" + this.streamId + " payload_len=" + this.cellBuffer.remaining() + " source=" + this.circuitNode + "]";
    }

    public String commandToString() {
        if (this.relayCommand == 9) {
            int code = this.getByteAt(14);
            return RelayCellImpl.commandToDescription(this.relayCommand) + " (" + CellImpl.errorToDescription(code) + ")";
        }
        if (this.relayCommand == 3) {
            int code = this.getByteAt(14);
            return RelayCellImpl.commandToDescription(this.relayCommand) + " (" + RelayCellImpl.reasonToDescription(code) + ")";
        }
        return RelayCellImpl.commandToDescription(this.relayCommand);
    }

    public static String reasonToDescription(int reasonCode) {
        switch (reasonCode) {
            case 1: {
                return "Unlisted reason";
            }
            case 2: {
                return "Couldn't look up hostname";
            }
            case 3: {
                return "Remote host refused connection";
            }
            case 4: {
                return "OR refuses to connect to host or port";
            }
            case 5: {
                return "Circuit is being destroyed";
            }
            case 6: {
                return "Anonymized TCP connection was closed";
            }
            case 7: {
                return "Connection timed out, or OR timed out while connecting";
            }
            case 9: {
                return "OR is temporarily hibernating";
            }
            case 10: {
                return "Internal error at the OR";
            }
            case 11: {
                return "OR has no resources to fulfill request";
            }
            case 12: {
                return "Connection was unexpectedly reset";
            }
            case 13: {
                return "Tor protocol violation";
            }
            case 14: {
                return "Client sent RELAY_BEGIN_DIR to a non-directory server.";
            }
        }
        return "Reason code " + reasonCode;
    }

    public static String commandToDescription(int command) {
        switch (command) {
            case 1: {
                return "RELAY_BEGIN";
            }
            case 2: {
                return "RELAY_DATA";
            }
            case 3: {
                return "RELAY_END";
            }
            case 4: {
                return "RELAY_CONNECTED";
            }
            case 5: {
                return "RELAY_SENDME";
            }
            case 6: {
                return "RELAY_EXTEND";
            }
            case 7: {
                return "RELAY_EXTENDED";
            }
            case 8: {
                return "RELAY_TRUNCATE";
            }
            case 9: {
                return "RELAY_TRUNCATED";
            }
            case 10: {
                return "RELAY_DROP";
            }
            case 11: {
                return "RELAY_RESOLVE";
            }
            case 12: {
                return "RELAY_RESOLVED";
            }
            case 13: {
                return "RELAY_BEGIN_DIR";
            }
            case 14: {
                return "RELAY_EXTEND2";
            }
            case 15: {
                return "RELAY_EXTENDED2";
            }
        }
        return "Relay command = " + command;
    }
}

