/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.data;

import android.util.Base64;
import java.math.BigDecimal;
import java.security.Key;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import milfont.com.tezosj_android.helper.Base58Check;
import milfont.com.tezosj_android.helper.Constants;
import milfont.com.tezosj_android.model.EncKeys;
import milfont.com.tezosj_android.model.SignedOperationGroup;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.encoders.Encoder;

public class TezosGateway {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType textPlainMT = MediaType.parse((String)"text/plain; charset=utf-8");
    private static final Integer HTTP_TIMEOUT = 20;

    private Object query(String endpoint, String data) throws Exception {
        JSONObject result = null;
        Boolean methodPost = false;
        Request request = null;
        MediaType MEDIA_PLAIN_TEXT_JSON = MediaType.parse((String)"application/json");
        String DEFAULT_PROVIDER = "https://rpc.tezrpc.me";
        RequestBody body = RequestBody.create((MediaType)textPlainMT, (String)(DEFAULT_PROVIDER + endpoint));
        if (data != null) {
            methodPost = true;
            body = RequestBody.create((MediaType)MEDIA_PLAIN_TEXT_JSON, (byte[])data.getBytes());
        }
        request = methodPost == false ? new Request.Builder().url(DEFAULT_PROVIDER + endpoint).build() : new Request.Builder().url(DEFAULT_PROVIDER + endpoint).addHeader("Content-Type", "text/plain").post(body).build();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).writeTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).readTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).build();
        try {
            Response response = client.newCall(request).execute();
            String strResponse = response.body().string();
            if (this.isJSONObject(strResponse).booleanValue()) {
                result = new JSONObject(strResponse);
            } else if (this.isJSONArray(strResponse).booleanValue()) {
                JSONArray myJSONArray = new JSONArray(strResponse);
                result = new JSONObject();
                result.put("result", (Object)myJSONArray);
            } else {
                result = new JSONObject();
                result.put("result", (Object)strResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new JSONObject();
            result.put("result", (Object)"An error occured when trying to do query operation. See details or stacktrace for more info.");
        }
        return result;
    }

    public JSONObject getHead() throws Exception {
        return (JSONObject)this.query("/chains/main/blocks/head", null);
    }

    public JSONObject getBalance(String address) throws Exception {
        JSONObject result = (JSONObject)this.query("/chains/main/blocks/head/context/contracts/" + address + "/balance", null);
        return result;
    }

    private JSONObject sendOperation(JSONArray operations, EncKeys encKeys) throws Exception {
        SignedOperationGroup signedOpGroup;
        String operationGroupHash;
        JSONObject result = new JSONObject();
        JSONObject head = new JSONObject();
        String forgedOperationGroup = "";
        head = (JSONObject)this.query("/chains/main/blocks/head/header", null);
        JSONObject appliedOp = this.applyOperation(head, operations, operationGroupHash = this.computeOperationHash(signedOpGroup = this.signOperationGroup(forgedOperationGroup = this.forgeOperations(head, operations), encKeys)), forgedOperationGroup, signedOpGroup);
        JSONObject opResult = this.checkAppliedOperationResults(appliedOp);
        if (opResult.get("result").toString().length() == 0) {
            String injectedOperation = this.injectOperation(signedOpGroup);
            String operation_result = (String)((JSONObject)((JSONObject)((JSONObject)((JSONArray)((JSONObject)((JSONArray)appliedOp.get("result")).get(0)).get("contents")).get(0)).get("metadata")).get("operation_result")).get("status");
            if (operation_result.equals("applied")) {
                operation_result = "Operation successful";
            }
            result.put("result", (Object)operation_result);
        } else {
            result.put("result", (Object)opResult.get("result").toString());
        }
        return result;
    }

    public JSONObject sendTransaction(String from, String to, BigDecimal amount, String fee, String gasLimit, String storageLimit, EncKeys encKeys) throws Exception {
        JSONObject result = new JSONObject();
        BigDecimal roundedAmount = amount.setScale(2, 4);
        JSONArray operations = new JSONArray();
        JSONObject transaction = new JSONObject();
        JSONObject head = new JSONObject();
        JSONObject account = new JSONObject();
        JSONObject parameters = new JSONObject();
        JSONArray argsArray = new JSONArray();
        Integer counter = 0;
        if (gasLimit == null) {
            gasLimit = "200";
        } else if (gasLimit.length() == 0 || gasLimit.equals("0")) {
            gasLimit = "200";
        }
        if (storageLimit == null) {
            storageLimit = "0";
        }
        head = new JSONObject(this.query("/chains/main/blocks/head/header", null).toString());
        account = this.getAccountForBlock(head.get("hash").toString(), from);
        counter = Integer.parseInt(account.get("counter").toString());
        transaction.put("destination", (Object)to);
        transaction.put("amount", (Object)String.valueOf(roundedAmount.multiply(BigDecimal.valueOf(Constants.UTEZ.intValue())).toBigInteger()));
        transaction.put("storage_limit", (Object)storageLimit);
        transaction.put("gas_limit", (Object)gasLimit);
        transaction.put("counter", (Object)String.valueOf(counter + 1));
        transaction.put("fee", (Object)fee);
        transaction.put("source", (Object)from);
        String OPERATION_KIND_TRANSACTION = "transaction";
        transaction.put("kind", (Object)OPERATION_KIND_TRANSACTION);
        parameters.put("prim", (Object)"Unit");
        parameters.put("args", (Object)argsArray);
        transaction.put("parameters", (Object)parameters);
        operations.put((Object)transaction);
        result = this.sendOperation(operations, encKeys);
        return result;
    }

    private SignedOperationGroup signOperationGroup(String forgedOperation, EncKeys encKeys) throws Exception {
        SignedOperationGroup signedOperationGroup = null;
        JSONObject signed = this.sign(Encoder.HEX.decode(forgedOperation), encKeys, "03");
        byte[] workBytes = ArrayUtils.addAll((byte[])Encoder.HEX.decode(forgedOperation), (byte[])Encoder.HEX.decode((String)signed.get("sig")));
        signedOperationGroup = new SignedOperationGroup(workBytes, (String)signed.get("edsig"), (String)signed.get("sbytes"));
        return signedOperationGroup;
    }

    private String forgeOperations(JSONObject blockHead, JSONArray operations) throws Exception {
        JSONObject result = new JSONObject();
        result.put("branch", blockHead.get("hash"));
        result.put("contents", (Object)operations);
        return this.nodeForgeOperations(result.toString());
    }

    private String nodeForgeOperations(String opGroup) throws Exception {
        JSONObject response = (JSONObject)this.query("/chains/main/blocks/head/helpers/forge/operations", opGroup);
        String forgedOperation = (String)response.get("result");
        return forgedOperation.replaceAll("\\n", "").replaceAll("\"", "").replaceAll("'", "");
    }

    private JSONObject getAccountForBlock(String blockHash, String accountID) throws Exception {
        JSONObject result = new JSONObject();
        result = (JSONObject)this.query("/chains/main/blocks/" + blockHash + "/context/contracts/" + accountID, null);
        return result;
    }

    private String computeOperationHash(SignedOperationGroup signedOpGroup) throws Exception {
        byte[] hash = new byte[32];
        NaCl.sodium();
        int r = Sodium.crypto_generichash((byte[])hash, (int)hash.length, (byte[])signedOpGroup.getTheBytes(), (int)signedOpGroup.getTheBytes().length, (byte[])signedOpGroup.getTheBytes(), (int)0);
        return Base58Check.encode(hash);
    }

    private JSONObject nodeApplyOperation(JSONArray payload) throws Exception {
        JSONObject response = (JSONObject)this.query("/chains/main/blocks/head/helpers/preapply/operations", payload.toString());
        return response;
    }

    private JSONObject applyOperation(JSONObject head, JSONArray operations, String operationGroupHash, String forgedOperationGroup, SignedOperationGroup signedOpGroup) throws Exception {
        JSONArray payload = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("protocol", head.get("protocol"));
        jsonObject.put("branch", head.get("hash"));
        jsonObject.put("contents", (Object)operations);
        jsonObject.put("signature", (Object)signedOpGroup.getSignature());
        payload.put((Object)jsonObject);
        return this.nodeApplyOperation(payload);
    }

    private JSONObject checkAppliedOperationResults(JSONObject appliedOp) throws Exception {
        JSONObject returned = new JSONObject();
        String error = "";
        String status = "";
        String[] validAppliedKinds = new String[]{"activate_account", "reveal", "transaction", "origination", "delegation"};
        JSONObject firstAppliedOp = new JSONObject();
        firstAppliedOp = appliedOp;
        String firstApplyed = firstAppliedOp.toString().replaceAll("\\\\n", "").replaceAll("\\\\", "");
        JSONArray result = new JSONArray(new JSONObject(firstApplyed).get("result").toString());
        JSONObject first = (JSONObject)result.get(0);
        if (first.has("kind")) {
            if (!Arrays.asList(validAppliedKinds).contains(first.get("kind").toString())) {
                returned.put("result", (Object)("Could not apply operation because: " + first.get("id")));
            } else {
                returned.put("result", (Object)"");
            }
        } else if (first.has("contents")) {
            JSONObject operation_result = (JSONObject)((JSONObject)((JSONObject)((JSONArray)first.get("contents")).get(0)).get("metadata")).get("operation_result");
            if (operation_result.has("status")) {
                status = (String)((JSONObject)((JSONObject)((JSONObject)((JSONArray)first.get("contents")).get(0)).get("metadata")).get("operation_result")).get("status");
                if (status.equals("applied")) {
                    returned.put("result", (Object)"");
                } else if (operation_result.has("errors")) {
                    error = (String)((JSONObject)((JSONArray)((JSONObject)((JSONObject)((JSONObject)((JSONArray)first.get("contents")).get(0)).get("metadata")).get("operation_result")).get("errors")).get(0)).get("id");
                    returned.put("result", (Object)("Error: " + operation_result));
                } else {
                    returned.put("result", (Object)"Error");
                }
            } else {
                returned.put("result", (Object)"Error");
            }
        } else {
            returned.put("result", (Object)"Error");
        }
        return returned;
    }

    private String injectOperation(SignedOperationGroup signedOpGroup) throws Exception {
        String payload = signedOpGroup.getSbytes();
        return this.nodeInjectOperation("\"" + payload + "\"");
    }

    private String nodeInjectOperation(String payload) throws Exception {
        JSONObject result = (JSONObject)this.query("/injection/operation?chain=main", payload);
        String injectedOperation = result.get("result").toString();
        return injectedOperation;
    }

    public JSONObject sign(byte[] bytes, EncKeys keys, String watermark) throws Exception {
        byte[] byteSk = keys.getEncPrivateKey();
        byte[] decSkBytes = TezosGateway.decryptBytes(byteSk, this.getEncryptionKey(keys));
        StringBuilder builder = new StringBuilder();
        for (byte decSkByte : decSkBytes) {
            builder.append((char)decSkByte);
        }
        byte[] edskPrefix = new byte[]{43, -10, 78, 7};
        byte[] decodedSk = Base58Check.decode(builder.toString());
        byte[] privateKeyBytes = Arrays.copyOfRange(decodedSk, edskPrefix.length, decodedSk.length);
        byte[] workBytes = ArrayUtils.addAll((byte[])bytes, (byte[])new byte[0]);
        if (watermark != null) {
            byte[] wmBytes = Encoder.HEX.decode(watermark);
            workBytes = ArrayUtils.addAll((byte[])wmBytes, (byte[])workBytes);
        }
        byte[] hashedWorkBytes = new byte[32];
        NaCl.sodium();
        int rc = Sodium.crypto_generichash((byte[])hashedWorkBytes, (int)hashedWorkBytes.length, (byte[])workBytes, (int)workBytes.length, (byte[])workBytes, (int)0);
        int[] lengths = new int[]{64};
        byte[] sig = new byte[64];
        NaCl.sodium();
        int r = Sodium.crypto_sign_detached((byte[])sig, (int[])lengths, (byte[])hashedWorkBytes, (int)hashedWorkBytes.length, (byte[])privateKeyBytes);
        byte[] edsigPrefix = new byte[]{9, -11, -51, -122, 18};
        byte[] edsigPrefixedSig = new byte[edsigPrefix.length + sig.length];
        edsigPrefixedSig = ArrayUtils.addAll((byte[])edsigPrefix, (byte[])sig);
        String edsig = Base58Check.encode(edsigPrefixedSig);
        String sbytes = Encoder.HEX.encode(bytes) + Encoder.HEX.encode(sig);
        JSONObject response = new JSONObject();
        response.put("bytes", (Object)Encoder.HEX.encode(bytes));
        response.put("sig", (Object)Encoder.HEX.encode(sig));
        response.put("edsig", (Object)edsig);
        response.put("sbytes", (Object)sbytes);
        return response;
    }

    private Boolean isJSONObject(String myStr) {
        try {
            JSONObject testJSON = new JSONObject(myStr);
            testJSON = null;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private Boolean isJSONArray(String myStr) {
        try {
            JSONArray testJSONArray = new JSONArray(myStr);
            testJSONArray = null;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private byte[] getEncryptionKey(EncKeys keys) {
        try {
            String base64EncryptedPassword = keys.getEncP();
            String base64EncryptionIv = keys.getEncIv();
            byte[] encryptionIv = Base64.decode((String)base64EncryptionIv, (int)0);
            byte[] encryptionPassword = Base64.decode((String)base64EncryptedPassword, (int)0);
            KeyStore keystore = KeyStore.getInstance("AndroidKeyStore");
            keystore.load(null);
            SecretKey secretKey = (SecretKey)keystore.getKey("tzj", null);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(encryptionIv));
            byte[] passwordBytes = cipher.doFinal(encryptionPassword);
            String password = new String(passwordBytes, "UTF-8");
            return passwordBytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static byte[] decryptBytes(byte[] encrypted, byte[] key) {
        try {
            SecretKeySpec keySpec = null;
            Cipher cipher = null;
            keySpec = new SecretKeySpec(key, "AES/ECB/PKCS7Padding");
            cipher = Cipher.getInstance("AES/ECB/PKCS7Padding");
            cipher.init(2, keySpec);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

