/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.helper;

import milfont.com.tezosj_android.helper.PrivateKey;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Point;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;
import org.libsodium.jni.keys.PublicKey;

public class KeyPair {
    private byte[] publicKey;
    private byte[] seed;
    private final byte[] secretKey;

    public KeyPair() {
        this.secretKey = Util.zeros((int)64);
        this.publicKey = Util.zeros((int)32);
        NaCl.sodium();
        Sodium.crypto_box_curve25519xsalsa20poly1305_keypair((byte[])this.publicKey, (byte[])this.secretKey);
    }

    public KeyPair(byte[] seed) {
        this.seed = seed;
        this.secretKey = Util.zeros((int)64);
        this.publicKey = Util.zeros((int)32);
        NaCl.sodium();
        Sodium.crypto_sign_seed_keypair((byte[])this.publicKey, (byte[])this.secretKey, (byte[])seed);
    }

    public KeyPair(String secretKey, Encoder encoder) {
        this(encoder.decode(secretKey));
    }

    public PublicKey getPublicKey() {
        Point point = new Point();
        byte[] key = this.publicKey != null ? this.publicKey : point.mult(this.secretKey).toBytes();
        return new PublicKey(key);
    }

    public PrivateKey getPrivateKey() {
        return new PrivateKey(this.secretKey);
    }
}

