/*
 * Decompiled with CFR 0.152.
 */
package milfont.com.tezosj_android.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import milfont.com.tezosj_android.helper.Base58;
import milfont.com.tezosj_android.helper.Base58Check;
import milfont.com.tezosj_android.helper.KeyPair;
import milfont.com.tezosj_android.helper.MyCryptoGenericHash;
import milfont.com.tezosj_android.helper.Sha256Hash;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bitcoinj.crypto.MnemonicCode;
import org.json.JSONArray;
import org.json.JSONObject;

public class TezosGateway {
    final String DEFAULT_PROVIDER = "https://tezrpc.me/api";
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType textPlainMT = MediaType.parse((String)"text/plain; charset=utf-8");
    public static final Integer HTTP_TIMEOUT = 20;

    public JSONObject generateKeys(String mnemonic, String passphrase) {
        JSONObject response = new JSONObject();
        try {
            MnemonicCode mc = new MnemonicCode();
            String cleanMnemonic = mnemonic.replace("[", "");
            cleanMnemonic = cleanMnemonic.replace("]", "");
            List<String> items = Arrays.asList(cleanMnemonic.split("\\s*,\\s*"));
            byte[] src_seed = MnemonicCode.toSeed(items, (String)passphrase);
            byte[] seed = Arrays.copyOfRange(src_seed, 0, 32);
            KeyPair key = new KeyPair(seed);
            byte[] sodiumPublicKey = key.getPublicKey().toBytes();
            byte[] sodiumPrivateKey = key.getPrivateKey().toBytes();
            byte[] edpkPrefix = new byte[]{13, 15, 37, -39};
            byte[] edskPrefix = new byte[]{43, -10, 78, 7};
            byte[] tz1Prefix = new byte[]{6, -95, -97};
            byte[] prefixedPubKey = new byte[36];
            System.arraycopy(edpkPrefix, 0, prefixedPubKey, 0, 4);
            System.arraycopy(sodiumPublicKey, 0, prefixedPubKey, 4, 32);
            byte[] firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedPubKey);
            byte[] prefixedPubKeyWithChecksum = new byte[40];
            System.arraycopy(prefixedPubKey, 0, prefixedPubKeyWithChecksum, 0, 36);
            System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedPubKeyWithChecksum, 36, 4);
            String TezosPkString = Base58.encode(prefixedPubKeyWithChecksum);
            byte[] prefixedSecKey = new byte[68];
            System.arraycopy(edskPrefix, 0, prefixedSecKey, 0, 4);
            System.arraycopy(sodiumPrivateKey, 0, prefixedSecKey, 4, 64);
            firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedSecKey);
            byte[] prefixedSecKeyWithChecksum = new byte[72];
            System.arraycopy(prefixedSecKey, 0, prefixedSecKeyWithChecksum, 0, 68);
            System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedSecKeyWithChecksum, 68, 4);
            String TezosSkString = Base58.encode(prefixedSecKeyWithChecksum);
            byte[] genericHash = new byte[20];
            genericHash = MyCryptoGenericHash.cryptoGenericHash(sodiumPublicKey, genericHash.length);
            byte[] prefixedGenericHash = new byte[23];
            System.arraycopy(tz1Prefix, 0, prefixedGenericHash, 0, 3);
            System.arraycopy(genericHash, 0, prefixedGenericHash, 3, 20);
            firstFourOfDoubleChecksum = Sha256Hash.hashTwiceThenFirstFourOnly(prefixedGenericHash);
            byte[] prefixedPKhashWithChecksum = new byte[27];
            System.arraycopy(prefixedGenericHash, 0, prefixedPKhashWithChecksum, 0, 23);
            System.arraycopy(firstFourOfDoubleChecksum, 0, prefixedPKhashWithChecksum, 23, 4);
            String pkHash = Base58.encode(prefixedPKhashWithChecksum);
            response.put("mnemonic", items);
            response.put("passphrase", (Object)passphrase);
            response.put("sk", (Object)TezosSkString);
            response.put("pk", (Object)TezosPkString);
            response.put("pkh", (Object)pkHash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public JSONObject generateKeysNoSeed() {
        JSONObject response = null;
        return response;
    }

    public JSONObject generateKeysSalted(String mnemonic, String passphrase) {
        JSONObject response = null;
        return response;
    }

    public JSONObject generateKeysFromSeedMulti(String mnemonic, String passphrase, Integer n) {
        JSONObject response = null;
        return response;
    }

    public JSONObject sign(Byte[] bytes, String sk) {
        JSONObject response = null;
        return response;
    }

    public Boolean verify(Byte[] bytes, String signature, String pk) {
        return false;
    }

    public String generateMnemonic() {
        String result = "";
        try {
            MnemonicCode mc = new MnemonicCode();
            byte[] bytes = new byte[20];
            new Random().nextBytes(bytes);
            List code = mc.toMnemonic(bytes);
            result = code.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Boolean checkAddress(String address) {
        Base58Check base58Check = new Base58Check();
        try {
            byte[] result = Base58Check.decode(address);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setProvider(String provider) {
    }

    public void resetProvider() {
    }

    public String query(String endpoint, String data) {
        String result = "";
        RequestBody body = RequestBody.create((MediaType)textPlainMT, (String)("https://tezrpc.me/api" + endpoint));
        if (data != null) {
            body = RequestBody.create((MediaType)JSON, (String)data);
        }
        Request request = new Request.Builder().url("https://tezrpc.me/api" + endpoint).post(body).build();
        try {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).writeTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).readTimeout((long)HTTP_TIMEOUT.intValue(), TimeUnit.SECONDS).build();
            Response response = client.newCall(request).execute();
            result = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public JSONObject getHead() throws Exception {
        String result = this.query("/blocks/head", null);
        JSONObject jobj = new JSONObject(result);
        return jobj;
    }

    public JSONObject sendOperation(JSONObject operation, String[] keys, Integer fee) {
        JSONObject response = null;
        return response;
    }

    public JSONObject getBalance(String address) throws Exception {
        String result = this.query("/blocks/prevalidation/proto/context/contracts/" + address + "/balance", null);
        JSONObject jobj = new JSONObject(result);
        return jobj;
    }

    public void originate(String address) {
    }

    public JSONObject storage(String contractAddress) {
        JSONObject response = null;
        return response;
    }

    public String load(String contractAddress) {
        String response = "";
        return response;
    }

    public JSONArray watch(String contractAddress, Integer interval) {
        JSONArray response = null;
        return response;
    }

    public JSONObject send(String contractAddress, String[] keys, Integer amount, String parameter, Integer fee) {
        JSONObject response = null;
        return response;
    }
}

