/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.StyleableRes;
import androidx.core.view.ViewCompat;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.iconics.IconicsColor;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.IconicsSize;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialize.util.UIUtils;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ.\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"\u00a8\u0006#"}, d2={"Lcom/mikepenz/materialdrawer/util/DrawerUIUtils;", "", "()V", "getBooleanStyleable", "", "ctx", "Landroid/content/Context;", "styleable", "", "def", "getDrawerItemBackground", "Landroid/graphics/drawable/StateListDrawable;", "selected_color", "getIconStateList", "icon", "Landroid/graphics/drawable/Drawable;", "selectedIcon", "getOptimalDrawerWidth", "context", "getPlaceHolder", "getTextColorStateList", "Landroid/content/res/ColorStateList;", "text_color", "selected_text_color", "isSystemBarOnBottom", "setDrawerVerticalPadding", "", "v", "Landroid/view/View;", "level", "themeDrawerItem", "view", "animate", "shapeAppearanceModel", "Lcom/google/android/material/shape/ShapeAppearanceModel;", "materialdrawer"})
@SuppressLint(value={"InlinedApi"})
public final class DrawerUIUtils {
    public static final DrawerUIUtils INSTANCE;

    public final boolean getBooleanStyleable(@NotNull Context ctx, @StyleableRes int styleable2, boolean def) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        TypedArray ta = ctx.getTheme().obtainStyledAttributes(R.styleable.MaterialDrawer);
        return ta.getBoolean(styleable2, def);
    }

    public final void themeDrawerItem(@NotNull Context ctx, @NotNull View view, int selected_color, boolean animate, @NotNull ShapeAppearanceModel shapeAppearanceModel) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)shapeAppearanceModel, (String)"shapeAppearanceModel");
        boolean legacyStyle = this.getBooleanStyleable(ctx, R.styleable.MaterialDrawer_material_drawer_legacy_style, false);
        Drawable selected = null;
        Drawable unselected = null;
        if (legacyStyle) {
            selected = (Drawable)new ColorDrawable(selected_color);
            Drawable drawable2 = UIUtils.getSelectableBackground((Context)ctx);
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"UIUtils.getSelectableBackground(ctx)");
            unselected = drawable2;
        } else {
            int paddingTopBottom = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_item_background_padding_top_bottom);
            int paddingStartEnd = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_item_background_padding_start_end);
            MaterialShapeDrawable gradientDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
            gradientDrawable.setFillColor(ColorStateList.valueOf((int)selected_color));
            selected = (Drawable)new InsetDrawable((Drawable)gradientDrawable, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
            if (Build.VERSION.SDK_INT >= 21) {
                MaterialShapeDrawable gradientMask = new MaterialShapeDrawable(shapeAppearanceModel);
                gradientMask.setFillColor(ColorStateList.valueOf((int)-16777216));
                InsetDrawable mask = new InsetDrawable((Drawable)gradientMask, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
                unselected = (Drawable)new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{UIUtils.getThemeColor((Context)ctx, (int)R.attr.colorControlHighlight)}), null, (Drawable)mask);
            } else {
                MaterialShapeDrawable touchDrawable = new MaterialShapeDrawable(shapeAppearanceModel);
                touchDrawable.setFillColor(ColorStateList.valueOf((int)UIUtils.getThemeColor((Context)ctx, (int)R.attr.colorControlHighlight)));
                InsetDrawable touchInsetDrawable = new InsetDrawable((Drawable)touchDrawable, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
                StateListDrawable unselectedStates = new StateListDrawable();
                if (animate) {
                    int duration = ctx.getResources().getInteger(0x10E0000);
                    unselectedStates.setEnterFadeDuration(duration);
                    unselectedStates.setExitFadeDuration(duration);
                }
                unselectedStates.addState(new int[]{16842919}, (Drawable)touchInsetDrawable);
                unselectedStates.addState(new int[0], (Drawable)new ColorDrawable(0));
                unselected = (Drawable)unselectedStates;
            }
        }
        StateListDrawable states = new StateListDrawable();
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            states.addState(new int[]{0x10100A1}, selected);
            states.addState(new int[0], (Drawable)new ColorDrawable(0));
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)states));
            view.setForeground(unselected);
        } else {
            states.addState(new int[]{0x10100A1}, selected);
            states.addState(new int[0], unselected);
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)states));
        }
    }

    @NotNull
    public final ColorStateList getTextColorStateList(int text_color, int selected_text_color) {
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, new int[0]}, new int[]{selected_text_color, text_color});
    }

    @NotNull
    public final StateListDrawable getIconStateList(@NotNull Drawable icon, @NotNull Drawable selectedIcon) {
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        Intrinsics.checkParameterIsNotNull((Object)selectedIcon, (String)"selectedIcon");
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }

    @NotNull
    public final StateListDrawable getDrawerItemBackground(int selected_color) {
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        return states;
    }

    public final int getOptimalDrawerWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int possibleMinDrawerWidth = UIUtils.getScreenWidth((Context)context) - UIUtils.getActionBarHeight((Context)context);
        int maxDrawerWidth = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_width);
        return Math.min(possibleMinDrawerWidth, maxDrawerWidth);
    }

    @NotNull
    public final Drawable getPlaceHolder(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        return (Drawable)new IconicsDrawable(ctx, (IIcon)MaterialDrawerFont.Icon.mdf_person).color(IconicsColor.Companion.colorRes(R.color.accent)).backgroundColor(IconicsColor.Companion.colorRes(R.color.primary)).size(IconicsSize.Companion.dp((Number)56)).padding(IconicsSize.Companion.dp((Number)16));
    }

    public final void setDrawerVerticalPadding(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Context context = v.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"v.context");
        int verticalPadding = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        v.setPadding(verticalPadding, 0, verticalPadding, 0);
    }

    public final void setDrawerVerticalPadding(@NotNull View v, int level) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Context context = v.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"v.context");
        int verticalPadding = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        if (Build.VERSION.SDK_INT >= 17) {
            v.setPaddingRelative(verticalPadding * level, 0, verticalPadding, 0);
        } else {
            v.setPadding(verticalPadding * level, 0, verticalPadding, 0);
        }
    }

    public final boolean isSystemBarOnBottom(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Object object = ctx.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        Resources resources = ctx.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"ctx.resources");
        Configuration cfg = resources.getConfiguration();
        boolean canMove = metrics.widthPixels != metrics.heightPixels && cfg.smallestScreenWidthDp < 600;
        return !canMove || metrics.widthPixels < metrics.heightPixels;
    }

    private DrawerUIUtils() {
    }

    static {
        DrawerUIUtils drawerUIUtils;
        INSTANCE = drawerUIUtils = new DrawerUIUtils();
    }
}

