/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import androidx.appcompat.content.res.AppCompatResources;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialize.holder.ColorHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mikepenz/materialdrawer/model/utils/BadgeDrawableBuilder;", "", "mStyle", "Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "(Lcom/mikepenz/materialdrawer/holder/BadgeStyle;)V", "build", "Landroid/graphics/drawable/StateListDrawable;", "ctx", "Landroid/content/Context;", "materialdrawer"})
public final class BadgeDrawableBuilder {
    private final BadgeStyle mStyle;

    @NotNull
    public final StateListDrawable build(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        StateListDrawable stateListDrawable = new StateListDrawable();
        GradientDrawable normal = (GradientDrawable)AppCompatResources.getDrawable((Context)ctx, (int)this.mStyle.getGradientDrawable());
        GradientDrawable gradientDrawable = normal;
        GradientDrawable selected = (GradientDrawable)(gradientDrawable != null && (gradientDrawable = gradientDrawable.getConstantState()) != null && (gradientDrawable = gradientDrawable.newDrawable()) != null ? gradientDrawable.mutate() : null);
        ColorHolder.applyToOrTransparent((ColorHolder)this.mStyle.getColor(), (Context)ctx, (GradientDrawable)normal);
        if (this.mStyle.getColorPressed() == null) {
            ColorHolder.applyToOrTransparent((ColorHolder)this.mStyle.getColor(), (Context)ctx, (GradientDrawable)selected);
        } else {
            ColorHolder.applyToOrTransparent((ColorHolder)this.mStyle.getColorPressed(), (Context)ctx, (GradientDrawable)selected);
        }
        DimenHolder dimenHolder = this.mStyle.getCorners();
        if (dimenHolder != null) {
            DimenHolder dimenHolder2 = dimenHolder;
            boolean bl = false;
            boolean bl2 = false;
            DimenHolder it = dimenHolder2;
            boolean bl3 = false;
            GradientDrawable gradientDrawable2 = normal;
            if (gradientDrawable2 != null) {
                gradientDrawable2.setCornerRadius((float)it.asPixel(ctx));
            }
            GradientDrawable gradientDrawable3 = selected;
            if (gradientDrawable3 != null) {
                gradientDrawable3.setCornerRadius((float)it.asPixel(ctx));
            }
        }
        stateListDrawable.addState(new int[]{16842919}, (Drawable)selected);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)normal);
        return stateListDrawable;
    }

    public BadgeDrawableBuilder(@NotNull BadgeStyle mStyle) {
        Intrinsics.checkParameterIsNotNull((Object)mStyle, (String)"mStyle");
        this.mStyle = mStyle;
    }
}

