/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00022\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u001aJ\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\nJ\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\nJ\u0010\u00106\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\nJ\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020 R\u0014\u0010\t\u001a\u00020\n8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\f\u00a8\u0006;"}, d2={"Lcom/mikepenz/materialdrawer/model/MiniDrawerItem;", "Lcom/mikepenz/materialdrawer/model/BaseDrawerItem;", "Lcom/mikepenz/materialdrawer/model/MiniDrawerItem$ViewHolder;", "primaryDrawerItem", "Lcom/mikepenz/materialdrawer/model/PrimaryDrawerItem;", "(Lcom/mikepenz/materialdrawer/model/PrimaryDrawerItem;)V", "secondaryDrawerItem", "Lcom/mikepenz/materialdrawer/model/SecondaryDrawerItem;", "(Lcom/mikepenz/materialdrawer/model/SecondaryDrawerItem;)V", "layoutRes", "", "getLayoutRes", "()I", "mBadge", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getMBadge", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setMBadge", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "mBadgeStyle", "Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "getMBadgeStyle", "()Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "setMBadgeStyle", "(Lcom/mikepenz/materialdrawer/holder/BadgeStyle;)V", "mCustomHeight", "Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "getMCustomHeight", "()Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "setMCustomHeight", "(Lcom/mikepenz/materialdrawer/holder/DimenHolder;)V", "mEnableSelectedBackground", "", "getMEnableSelectedBackground", "()Z", "setMEnableSelectedBackground", "(Z)V", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "withCustomHeight", "customHeight", "withCustomHeightDp", "customHeightDp", "withCustomHeightPx", "customHeightPx", "withCustomHeightRes", "customHeightRes", "withEnableSelectedBackground", "enableSelectedBackground", "ViewHolder", "materialdrawer"})
public class MiniDrawerItem
extends BaseDrawerItem<MiniDrawerItem, ViewHolder> {
    @Nullable
    private StringHolder mBadge;
    @Nullable
    private BadgeStyle mBadgeStyle;
    private boolean mEnableSelectedBackground;
    @Nullable
    private DimenHolder mCustomHeight;

    @Nullable
    public final StringHolder getMBadge() {
        return this.mBadge;
    }

    public final void setMBadge(@Nullable StringHolder stringHolder) {
        this.mBadge = stringHolder;
    }

    @Nullable
    public final BadgeStyle getMBadgeStyle() {
        return this.mBadgeStyle;
    }

    public final void setMBadgeStyle(@Nullable BadgeStyle badgeStyle) {
        this.mBadgeStyle = badgeStyle;
    }

    public final boolean getMEnableSelectedBackground() {
        return this.mEnableSelectedBackground;
    }

    public final void setMEnableSelectedBackground(boolean bl) {
        this.mEnableSelectedBackground = bl;
    }

    @Nullable
    public final DimenHolder getMCustomHeight() {
        return this.mCustomHeight;
    }

    public final void setMCustomHeight(@Nullable DimenHolder dimenHolder) {
        this.mCustomHeight = dimenHolder;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_mini;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_mini;
    }

    @NotNull
    public final MiniDrawerItem withCustomHeightRes(@DimenRes int customHeightRes) {
        this.mCustomHeight = DimenHolder.Companion.fromResource(customHeightRes);
        return this;
    }

    @NotNull
    public final MiniDrawerItem withCustomHeightDp(int customHeightDp) {
        this.mCustomHeight = DimenHolder.Companion.fromDp(customHeightDp);
        return this;
    }

    @NotNull
    public final MiniDrawerItem withCustomHeightPx(int customHeightPx) {
        this.mCustomHeight = DimenHolder.Companion.fromPixel(customHeightPx);
        return this;
    }

    @NotNull
    public final MiniDrawerItem withCustomHeight(@NotNull DimenHolder customHeight) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)customHeight), (String)"customHeight");
        this.mCustomHeight = customHeight;
        return this;
    }

    @NotNull
    public final MiniDrawerItem withEnableSelectedBackground(boolean enableSelectedBackground) {
        this.mEnableSelectedBackground = enableSelectedBackground;
        return this;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<Object> payloads) {
        boolean badgeVisible;
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context ctx = view.getContext();
        DimenHolder dimenHolder = this.mCustomHeight;
        if (dimenHolder != null) {
            DimenHolder dimenHolder2 = dimenHolder;
            boolean bl = false;
            boolean bl2 = false;
            DimenHolder it = dimenHolder2;
            boolean bl3 = false;
            View view2 = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.LayoutParams");
            }
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)layoutParams;
            lp.height = it.asPixel(ctx);
            View view3 = holder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"holder.itemView");
            view3.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        View view4 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"holder.itemView");
        view4.setId(this.hashCode());
        View view5 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"holder.itemView");
        view5.setEnabled(this.isEnabled());
        View view6 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"holder.itemView");
        view6.setSelected(this.isSelected());
        View view7 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"holder.itemView");
        view7.setTag((Object)this);
        Context context = ctx;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
        int iconColor = this.getIconColor(context);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        ShapeAppearanceModel shapeAppearanceModel = this.getShapeAppearanceModel(ctx);
        if (this.mEnableSelectedBackground) {
            int selectedColor = this.getSelectedColor(ctx);
            DrawerUIUtils.INSTANCE.themeDrawerItem(ctx, holder.getView$materialdrawer(), selectedColor, this.isSelectedBackgroundAnimated(), shapeAppearanceModel);
        }
        if (badgeVisible = StringHolder.Companion.applyToOrHide(this.mBadge, holder.getBadge$materialdrawer())) {
            BadgeStyle badgeStyle = this.mBadgeStyle;
            if (badgeStyle != null) {
                BadgeStyle.style$default(badgeStyle, holder.getBadge$materialdrawer(), null, 2, null);
            }
        }
        Drawable icon = ImageHolder.Companion.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
        Drawable selectedIcon = ImageHolder.Companion.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
        ImageHolder.Companion.applyMultiIconTo(icon, iconColor, selectedIcon, selectedIconColor, this.isIconTinted(), holder.getIcon$materialdrawer());
        int verticalPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
        int topBottomPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_mini_drawer_item_padding);
        holder.itemView.setPadding(verticalPadding, topBottomPadding, verticalPadding, topBottomPadding);
        IDrawerItem iDrawerItem = this;
        View view8 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view8);
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    public MiniDrawerItem(@NotNull PrimaryDrawerItem primaryDrawerItem) {
        Intrinsics.checkParameterIsNotNull((Object)primaryDrawerItem, (String)"primaryDrawerItem");
        this.mBadgeStyle = new BadgeStyle();
        this.setIdentifier(primaryDrawerItem.getIdentifier());
        this.setTag(primaryDrawerItem.getTag());
        this.mBadge = primaryDrawerItem.getBadge();
        this.mBadgeStyle = primaryDrawerItem.getBadgeStyle();
        this.setEnabled(primaryDrawerItem.isEnabled());
        this.setSelectable(primaryDrawerItem.isSelectable());
        this.setSelected(primaryDrawerItem.isSelected());
        this.setIcon(primaryDrawerItem.getIcon());
        this.setSelectedIcon(primaryDrawerItem.getSelectedIcon());
        this.setIconTinted(primaryDrawerItem.isIconTinted());
        this.setSelectedColor(primaryDrawerItem.getSelectedColor());
        this.setIconColor(primaryDrawerItem.getIconColor());
        this.setSelectedIconColor(primaryDrawerItem.getSelectedIconColor());
        this.setDisabledIconColor(primaryDrawerItem.getDisabledIconColor());
    }

    public MiniDrawerItem(@NotNull SecondaryDrawerItem secondaryDrawerItem) {
        Intrinsics.checkParameterIsNotNull((Object)secondaryDrawerItem, (String)"secondaryDrawerItem");
        this.mBadgeStyle = new BadgeStyle();
        this.setIdentifier(secondaryDrawerItem.getIdentifier());
        this.setTag(secondaryDrawerItem.getTag());
        this.mBadge = secondaryDrawerItem.getBadge();
        this.mBadgeStyle = secondaryDrawerItem.getBadgeStyle();
        this.setEnabled(secondaryDrawerItem.isEnabled());
        this.setSelectable(secondaryDrawerItem.isSelectable());
        this.setSelected(secondaryDrawerItem.isSelected());
        this.setIcon(secondaryDrawerItem.getIcon());
        this.setSelectedIcon(secondaryDrawerItem.getSelectedIcon());
        this.setIconTinted(secondaryDrawerItem.isIconTinted());
        this.setSelectedColor(secondaryDrawerItem.getSelectedColor());
        this.setIconColor(secondaryDrawerItem.getIconColor());
        this.setSelectedIconColor(secondaryDrawerItem.getSelectedIconColor());
        this.setDisabledIconColor(secondaryDrawerItem.getDisabledIconColor());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/mikepenz/materialdrawer/model/MiniDrawerItem$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "badge", "Landroid/widget/TextView;", "getBadge$materialdrawer", "()Landroid/widget/TextView;", "icon", "Landroid/widget/ImageView;", "getIcon$materialdrawer", "()Landroid/widget/ImageView;", "getView$materialdrawer", "()Landroid/view/View;", "materialdrawer"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView icon;
        @NotNull
        private final TextView badge;
        @NotNull
        private final View view;

        @NotNull
        public final ImageView getIcon$materialdrawer() {
            return this.icon;
        }

        @NotNull
        public final TextView getBadge$materialdrawer() {
            return this.badge;
        }

        @NotNull
        public final View getView$materialdrawer() {
            return this.view;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            this.view = view;
            View view2 = this.view.findViewById(R.id.material_drawer_icon);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById<ImageV\u2026.id.material_drawer_icon)");
            this.icon = (ImageView)view2;
            View view3 = this.view.findViewById(R.id.material_drawer_badge);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById<TextVi\u2026id.material_drawer_badge)");
            this.badge = (TextView)view3;
        }
    }
}

