/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.iconics.IconicsColor;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.IconicsSize;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.ColorfulBadgeable;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00022\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u000203H\u0016J\u0012\u00104\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u00104\u001a\u00020\u00002\b\b\u0001\u00105\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u000206H\u0016J\u0012\u00107\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u00108\u001a\u00020\u00002\u0006\u0010$\u001a\u00020#H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000e\u00a8\u0006:"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem;", "Lcom/mikepenz/materialdrawer/model/BaseDescribeableDrawerItem;", "Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/interfaces/ColorfulBadgeable;", "()V", "arrowColor", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getArrowColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setArrowColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "arrowRotationAngleEnd", "", "getArrowRotationAngleEnd", "()I", "setArrowRotationAngleEnd", "(I)V", "arrowRotationAngleStart", "getArrowRotationAngleStart", "setArrowRotationAngleStart", "badge", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getBadge", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setBadge", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "badgeStyle", "Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "getBadgeStyle", "()Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "setBadgeStyle", "(Lcom/mikepenz/materialdrawer/holder/BadgeStyle;)V", "layoutRes", "getLayoutRes", "mOnDrawerItemClickListener", "Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;", "onDrawerItemClickListener", "getOnDrawerItemClickListener", "()Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;", "setOnDrawerItemClickListener", "(Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;)V", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "withBadge", "badgeRes", "", "withBadgeStyle", "withOnDrawerItemClickListener", "ViewHolder", "materialdrawer"})
public class ExpandableBadgeDrawerItem
extends BaseDescribeableDrawerItem<ExpandableBadgeDrawerItem, ViewHolder>
implements ColorfulBadgeable<ExpandableBadgeDrawerItem> {
    private Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener;
    @Nullable
    private ColorHolder arrowColor;
    private int arrowRotationAngleStart;
    private int arrowRotationAngleEnd = 180;
    @Nullable
    private StringHolder badge;
    @Nullable
    private BadgeStyle badgeStyle = new BadgeStyle();
    @Nullable
    private Drawer.OnDrawerItemClickListener onDrawerItemClickListener = new Drawer.OnDrawerItemClickListener(this){
        final /* synthetic */ ExpandableBadgeDrawerItem this$0;

        public boolean onItemClick(@Nullable View view, int position, @NotNull IDrawerItem<?> drawerItem) {
            Intrinsics.checkParameterIsNotNull(drawerItem, (String)"drawerItem");
            if (drawerItem instanceof AbstractDrawerItem && drawerItem.isEnabled() && drawerItem.getSubItems() != null) {
                View view2 = view;
                if (view2 != null) {
                    View view3 = view2;
                    boolean bl = false;
                    boolean bl2 = false;
                    View it = view3;
                    boolean bl3 = false;
                    if (drawerItem.isExpanded()) {
                        ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleEnd()).start();
                    } else {
                        ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleStart()).start();
                    }
                }
            }
            Drawer.OnDrawerItemClickListener onDrawerItemClickListener2 = ExpandableBadgeDrawerItem.access$getMOnDrawerItemClickListener$p(this.this$0);
            return onDrawerItemClickListener2 != null ? onDrawerItemClickListener2.onItemClick(view, position, drawerItem) : false;
        }
        {
            this.this$0 = $outer;
        }
    };

    @Nullable
    public final ColorHolder getArrowColor() {
        return this.arrowColor;
    }

    public final void setArrowColor(@Nullable ColorHolder colorHolder) {
        this.arrowColor = colorHolder;
    }

    public final int getArrowRotationAngleStart() {
        return this.arrowRotationAngleStart;
    }

    public final void setArrowRotationAngleStart(int n) {
        this.arrowRotationAngleStart = n;
    }

    public final int getArrowRotationAngleEnd() {
        return this.arrowRotationAngleEnd;
    }

    public final void setArrowRotationAngleEnd(int n) {
        this.arrowRotationAngleEnd = n;
    }

    @Override
    @Nullable
    public StringHolder getBadge() {
        return this.badge;
    }

    public void setBadge(@Nullable StringHolder stringHolder) {
        this.badge = stringHolder;
    }

    @Override
    @Nullable
    public BadgeStyle getBadgeStyle() {
        return this.badgeStyle;
    }

    public void setBadgeStyle(@Nullable BadgeStyle badgeStyle) {
        this.badgeStyle = badgeStyle;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_expandable_badge;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_expandable_badge;
    }

    @Override
    @Nullable
    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.onDrawerItemClickListener;
    }

    @Override
    public void setOnDrawerItemClickListener(@Nullable Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        this.onDrawerItemClickListener = onDrawerItemClickListener2;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<Object> payloads) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context ctx = view.getContext();
        this.bindViewHelper(holder);
        boolean badgeVisible = StringHolder.Companion.applyToOrHide(this.getBadge(), holder.getBadge());
        if (badgeVisible) {
            BadgeStyle badgeStyle = this.getBadgeStyle();
            if (badgeStyle != null) {
                TextView textView = holder.getBadge();
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                badgeStyle.style(textView, this.getTextColorStateList(this.getColor(context), this.getSelectedTextColor(ctx)));
            }
            holder.getBadgeContainer().setVisibility(0);
        } else {
            holder.getBadgeContainer().setVisibility(8);
        }
        if (this.getTypeface() != null) {
            holder.getBadge().setTypeface(this.getTypeface());
        }
        if (holder.getArrow().getDrawable() instanceof IconicsDrawable) {
            int n;
            Drawable drawable2 = holder.getArrow().getDrawable();
            if (drawable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.iconics.IconicsDrawable");
            }
            IconicsDrawable iconicsDrawable = (IconicsDrawable)drawable2;
            ColorHolder colorHolder = this.arrowColor;
            if (colorHolder != null) {
                n = colorHolder.color(ctx);
            } else {
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                n = this.getIconColor(context);
            }
            iconicsDrawable.color(IconicsColor.Companion.colorInt(n));
        }
        holder.getArrow().clearAnimation();
        if (!this.isExpanded()) {
            holder.getArrow().setRotation((float)this.arrowRotationAngleStart);
        } else {
            holder.getArrow().setRotation((float)this.arrowRotationAngleEnd);
        }
        IDrawerItem iDrawerItem = this;
        View view2 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view2);
    }

    @Override
    @NotNull
    public ExpandableBadgeDrawerItem withOnDrawerItemClickListener(@NotNull Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        Intrinsics.checkParameterIsNotNull((Object)onDrawerItemClickListener2, (String)"onDrawerItemClickListener");
        this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
        return this;
    }

    @Override
    @NotNull
    public ExpandableBadgeDrawerItem withBadge(@Nullable StringHolder badge) {
        this.setBadge(badge);
        return this;
    }

    @Override
    @NotNull
    public ExpandableBadgeDrawerItem withBadge(@NotNull String badge) {
        Intrinsics.checkParameterIsNotNull((Object)badge, (String)"badge");
        this.setBadge(new StringHolder(badge));
        return this;
    }

    @Override
    @NotNull
    public ExpandableBadgeDrawerItem withBadge(@StringRes int badgeRes) {
        this.setBadge(new StringHolder(badgeRes));
        return this;
    }

    @Override
    @NotNull
    public ExpandableBadgeDrawerItem withBadgeStyle(@Nullable BadgeStyle badgeStyle) {
        this.setBadgeStyle(badgeStyle);
        return this;
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    public static final /* synthetic */ Drawer.OnDrawerItemClickListener access$getMOnDrawerItemClickListener$p(ExpandableBadgeDrawerItem $this) {
        return $this.mOnDrawerItemClickListener;
    }

    public static final /* synthetic */ void access$setMOnDrawerItemClickListener$p(ExpandableBadgeDrawerItem $this, Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        $this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableBadgeDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/BaseViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "arrow", "Landroid/widget/ImageView;", "getArrow", "()Landroid/widget/ImageView;", "setArrow", "(Landroid/widget/ImageView;)V", "badge", "Landroid/widget/TextView;", "getBadge", "()Landroid/widget/TextView;", "setBadge", "(Landroid/widget/TextView;)V", "badgeContainer", "getBadgeContainer", "()Landroid/view/View;", "setBadgeContainer", "materialdrawer"})
    public static final class ViewHolder
    extends BaseViewHolder {
        @NotNull
        private ImageView arrow;
        @NotNull
        private View badgeContainer;
        @NotNull
        private TextView badge;

        @NotNull
        public final ImageView getArrow() {
            return this.arrow;
        }

        public final void setArrow(@NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
            this.arrow = imageView;
        }

        @NotNull
        public final View getBadgeContainer() {
            return this.badgeContainer;
        }

        public final void setBadgeContainer(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"<set-?>");
            this.badgeContainer = view;
        }

        @NotNull
        public final TextView getBadge() {
            return this.badge;
        }

        public final void setBadge(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"<set-?>");
            this.badge = textView;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            View view2 = view.findViewById(R.id.material_drawer_arrow);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.material_drawer_arrow)");
            this.arrow = (ImageView)view2;
            View view3 = view.findViewById(R.id.material_drawer_badge_container);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.m\u2026l_drawer_badge_container)");
            this.badgeContainer = view3;
            View view4 = view.findViewById(R.id.material_drawer_badge);
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view.findViewById(R.id.material_drawer_badge)");
            this.badge = (TextView)view4;
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            this.arrow.setImageDrawable((Drawable)new IconicsDrawable(context, (IIcon)MaterialDrawerFont.Icon.mdf_expand_more).size(IconicsSize.Companion.dp((Number)16)).padding(IconicsSize.Companion.dp((Number)2)).color(IconicsColor.Companion.colorInt(-16777216)));
        }
    }
}

