/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0004J\u0015\u0010\u0015\u001a\u00028\u00002\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\b\b\u0001\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u001d\u001a\u00028\u00002\b\b\u0001\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/mikepenz/materialdrawer/model/BaseDescribeableDrawerItem;", "T", "VH", "Lcom/mikepenz/materialdrawer/model/BaseViewHolder;", "Lcom/mikepenz/materialdrawer/model/BaseDrawerItem;", "()V", "description", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getDescription", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setDescription", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "descriptionTextColor", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getDescriptionTextColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setDescriptionTextColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "bindViewHelper", "", "viewHolder", "withDescription", "descriptionRes", "", "(I)Ljava/lang/Object;", "", "(Ljava/lang/String;)Ljava/lang/Object;", "withDescriptionTextColor", "color", "withDescriptionTextColorRes", "colorRes", "materialdrawer"})
public abstract class BaseDescribeableDrawerItem<T, VH extends BaseViewHolder>
extends BaseDrawerItem<T, VH> {
    @Nullable
    private StringHolder description;
    @Nullable
    private ColorHolder descriptionTextColor;

    @Nullable
    public final StringHolder getDescription() {
        return this.description;
    }

    public final void setDescription(@Nullable StringHolder stringHolder) {
        this.description = stringHolder;
    }

    @Nullable
    public final ColorHolder getDescriptionTextColor() {
        return this.descriptionTextColor;
    }

    public final void setDescriptionTextColor(@Nullable ColorHolder colorHolder) {
        this.descriptionTextColor = colorHolder;
    }

    public final T withDescription(@NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.description = new StringHolder(description);
        return (T)this;
    }

    public final T withDescription(@StringRes int descriptionRes) {
        this.description = new StringHolder(descriptionRes);
        return (T)this;
    }

    public final T withDescriptionTextColor(@ColorInt int color2) {
        this.descriptionTextColor = ColorHolder.Companion.fromColor(color2);
        return (T)this;
    }

    public final T withDescriptionTextColorRes(@ColorRes int colorRes) {
        this.descriptionTextColor = ColorHolder.Companion.fromColorRes(colorRes);
        return (T)this;
    }

    protected final void bindViewHelper(@NotNull BaseViewHolder viewHolder) {
        Drawable icon;
        Intrinsics.checkParameterIsNotNull((Object)((Object)viewHolder), (String)"viewHolder");
        View view = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
        Context ctx = view.getContext();
        View view2 = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"viewHolder.itemView");
        view2.setId(this.hashCode());
        View view3 = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"viewHolder.itemView");
        view3.setSelected(this.isSelected());
        View view4 = viewHolder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"viewHolder.itemView");
        view4.setEnabled(this.isEnabled());
        Context context = ctx;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
        int selectedColor = this.getSelectedColor(context);
        int color2 = this.getColor(ctx);
        ColorStateList selectedTextColor = this.getTextColorStateList(color2, this.getSelectedTextColor(ctx));
        int iconColor = this.getIconColor(ctx);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        ShapeAppearanceModel shapeAppearanceModel = this.getShapeAppearanceModel(ctx);
        DrawerUIUtils.INSTANCE.themeDrawerItem(ctx, viewHolder.getView$materialdrawer(), selectedColor, this.isSelectedBackgroundAnimated(), shapeAppearanceModel);
        StringHolder.Companion.applyTo(this.getName(), viewHolder.getName$materialdrawer());
        StringHolder.Companion.applyToOrHide(this.description, viewHolder.getDescription$materialdrawer());
        viewHolder.getName$materialdrawer().setTextColor(selectedTextColor);
        ColorHolder colorHolder = this.descriptionTextColor;
        if (colorHolder != null) {
            colorHolder.applyToOr(viewHolder.getDescription$materialdrawer(), selectedTextColor);
        }
        if (this.getTypeface() != null) {
            viewHolder.getName$materialdrawer().setTypeface(this.getTypeface());
            viewHolder.getDescription$materialdrawer().setTypeface(this.getTypeface());
        }
        if ((icon = ImageHolder.Companion.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1)) != null) {
            Drawable selectedIcon = ImageHolder.Companion.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
            ImageHolder.Companion.applyMultiIconTo(icon, iconColor, selectedIcon, selectedIconColor, this.isIconTinted(), viewHolder.getIcon$materialdrawer());
        } else {
            ImageHolder.Companion.applyDecidedIconOrSetGone((ImageHolder)icon, viewHolder.getIcon$materialdrawer(), iconColor, this.isIconTinted(), 1);
        }
        DrawerUIUtils.INSTANCE.setDrawerVerticalPadding(viewHolder.getView$materialdrawer(), this.getLevel());
    }
}

