/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.support.annotation.NonNull;
import com.mikepenz.materialdrawer.model.interfaces.Identifyable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class IdDistributor {
    private static AtomicInteger idDistributor = new AtomicInteger(2000000000);

    public static <T extends Identifyable> ArrayList<T> checkIds(@NonNull ArrayList<T> items) {
        for (Identifyable item : items) {
            IdDistributor.checkId(item);
        }
        return items;
    }

    public static <T extends Identifyable> T[] checkIds(T ... items) {
        for (T item : items) {
            IdDistributor.checkId(item);
        }
        return items;
    }

    public static <T extends Identifyable> T checkId(@NonNull T item) {
        if (item.getIdentifier() == -1) {
            item.withIdentifier(idDistributor.incrementAndGet());
        }
        return item;
    }
}

