/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialize.util.UIUtils;

@SuppressLint(value={"InlinedApi"})
public class DrawerUIUtils {
    public static ColorStateList getTextColorStateList(int text_color, int selected_text_color) {
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, new int[0]}, new int[]{selected_text_color, text_color});
    }

    public static StateListDrawable getIconStateList(Drawable icon, Drawable selectedIcon) {
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }

    public static StateListDrawable getDrawerItemBackground(int selected_color) {
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        return states;
    }

    public static StateListDrawable getSelectableBackground(Context ctx, int selected_color) {
        StateListDrawable states = DrawerUIUtils.getDrawerItemBackground(selected_color);
        states.addState(new int[0], UIUtils.getCompatDrawable((Context)ctx, (int)DrawerUIUtils.getSelectableBackground(ctx)));
        return states;
    }

    public static int getSelectableBackground(Context ctx) {
        if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            ctx.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
            return outValue.resourceId;
        }
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(0x1010130, outValue, true);
        return outValue.resourceId;
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static int getOptimalDrawerWidth(Context context) {
        int possibleMinDrawerWidth = DrawerUIUtils.getScreenWidth(context) - UIUtils.getActionBarHeight((Context)context);
        int maxDrawerWidth = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_width);
        return Math.min(possibleMinDrawerWidth, maxDrawerWidth);
    }

    public static Drawable getPlaceHolder(Context ctx) {
        return new IconicsDrawable(ctx, (IIcon)MaterialDrawerFont.Icon.mdf_person).colorRes(R.color.accent).backgroundColorRes(R.color.primary).sizeDp(56).paddingDp(16);
    }

    public static void setDrawerVerticalPadding(View v) {
        int verticalPadding = v.getContext().getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        v.setPadding(verticalPadding, 0, verticalPadding, 0);
    }

    public static void setDrawerVerticalPadding(View v, int level) {
        int verticalPadding = v.getContext().getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        if (Build.VERSION.SDK_INT >= 17) {
            v.setPaddingRelative(verticalPadding * level, 0, verticalPadding, 0);
        } else {
            v.setPadding(verticalPadding * level, 0, verticalPadding, 0);
        }
    }
}

