/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;
import java.util.ArrayList;
import java.util.Collections;

public class DrawerItemViewHelper {
    private Context mContext;
    private ArrayList<IDrawerItem> mDrawerItems = new ArrayList();
    private boolean mDivider = true;
    private OnDrawerItemClickListener mOnDrawerItemClickListener = null;

    public DrawerItemViewHelper(Context context) {
        this.mContext = context;
    }

    public DrawerItemViewHelper withDrawerItems(ArrayList<IDrawerItem> drawerItems) {
        this.mDrawerItems = drawerItems;
        return this;
    }

    public DrawerItemViewHelper withDrawerItems(IDrawerItem ... drawerItems) {
        Collections.addAll(this.mDrawerItems, drawerItems);
        return this;
    }

    public DrawerItemViewHelper withDivider(boolean divider) {
        this.mDivider = divider;
        return this;
    }

    public DrawerItemViewHelper withOnDrawerItemClickListener(OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener;
        return this;
    }

    public View build() {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        if (this.mDivider) {
            LinearLayout divider = new LinearLayout(this.mContext);
            divider.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            divider.setMinimumHeight((int)UIUtils.convertDpToPixel((float)1.0f, (Context)this.mContext));
            divider.setOrientation(1);
            divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)this.mContext, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
            linearLayout.addView((View)divider);
        }
        for (IDrawerItem drawerItem : this.mDrawerItems) {
            View view = drawerItem.generateView(this.mContext);
            view.setTag((Object)drawerItem);
            if (drawerItem.isEnabled()) {
                view.setBackgroundResource(DrawerUIUtils.getSelectableBackground(this.mContext));
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (DrawerItemViewHelper.this.mOnDrawerItemClickListener != null) {
                            DrawerItemViewHelper.this.mOnDrawerItemClickListener.onItemClick(v, (IDrawerItem)v.getTag());
                        }
                    }
                });
            }
            linearLayout.addView(view);
        }
        return linearLayout;
    }

    public static interface OnDrawerItemClickListener {
        public void onItemClick(View var1, IDrawerItem var2);
    }
}

