/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.mikepenz.materialdrawer.util.AbstractDrawerImageLoader;

public class DrawerImageLoader {
    private static DrawerImageLoader SINGLETON = null;
    private IDrawerImageLoader imageLoader;
    private boolean mHandleAllUris = false;

    private DrawerImageLoader(IDrawerImageLoader loaderImpl) {
        this.imageLoader = loaderImpl;
    }

    public static DrawerImageLoader init(IDrawerImageLoader loaderImpl) {
        SINGLETON = new DrawerImageLoader(loaderImpl);
        return SINGLETON;
    }

    public static DrawerImageLoader getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new DrawerImageLoader(new AbstractDrawerImageLoader(){});
        }
        return SINGLETON;
    }

    public DrawerImageLoader withHandleAllUris(boolean handleAllUris) {
        this.mHandleAllUris = handleAllUris;
        return this;
    }

    public boolean setImage(ImageView imageView, Uri uri, String tag) {
        if (this.mHandleAllUris || "http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
            if (this.imageLoader != null) {
                Drawable placeHolder = this.imageLoader.placeholder(imageView.getContext(), tag);
                this.imageLoader.set(imageView, uri, placeHolder);
            }
            return true;
        }
        return false;
    }

    public void cancelImage(ImageView imageView) {
        if (this.imageLoader != null) {
            this.imageLoader.cancel(imageView);
        }
    }

    public IDrawerImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(IDrawerImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public static interface IDrawerImageLoader {
        public void set(ImageView var1, Uri var2, Drawable var3);

        public void cancel(ImageView var1);

        public Drawable placeholder(Context var1);

        public Drawable placeholder(Context var1, String var2);
    }

    public static enum Tags {
        PROFILE,
        PROFILE_DRAWER_ITEM,
        ACCOUNT_HEADER;

    }
}

