/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.ToggleButton;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.interfaces.OnCheckedChangeListener;
import com.mikepenz.materialdrawer.model.BasePrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;

public class ToggleDrawerItem
extends BasePrimaryDrawerItem<ToggleDrawerItem> {
    private boolean toggleEnabled = true;
    private boolean checked = false;
    private OnCheckedChangeListener onCheckedChangeListener = null;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (ToggleDrawerItem.this.isEnabled()) {
                ToggleDrawerItem.this.checked = isChecked;
                if (ToggleDrawerItem.this.getOnCheckedChangeListener() != null) {
                    ToggleDrawerItem.this.getOnCheckedChangeListener().onCheckedChanged(ToggleDrawerItem.this, buttonView, isChecked);
                }
            } else {
                buttonView.setOnCheckedChangeListener(null);
                buttonView.setChecked(!isChecked);
                buttonView.setOnCheckedChangeListener(ToggleDrawerItem.this.checkedChangeListener);
            }
        }
    };

    public ToggleDrawerItem withChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public ToggleDrawerItem withToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
        return this;
    }

    public ToggleDrawerItem withOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isToggleEnabled() {
        return this.toggleEnabled;
    }

    public void setToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
    }

    public OnCheckedChangeListener getOnCheckedChangeListener() {
        return this.onCheckedChangeListener;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
    }

    @Override
    public String getType() {
        return "TOGGLE_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_toggle;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        final ViewHolder viewHolder = (ViewHolder)holder;
        this.bindViewHelper((BasePrimaryDrawerItem.BaseViewHolder)holder);
        viewHolder.toggle.setOnCheckedChangeListener(null);
        viewHolder.toggle.setChecked(this.checked);
        viewHolder.toggle.setOnCheckedChangeListener(this.checkedChangeListener);
        viewHolder.toggle.setEnabled(this.toggleEnabled);
        this.withOnDrawerItemClickListener(new Drawer.OnDrawerItemClickListener(){

            @Override
            public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
                if (!ToggleDrawerItem.this.isSelectable()) {
                    ToggleDrawerItem.this.checked = !ToggleDrawerItem.this.checked;
                    viewHolder.toggle.setChecked(ToggleDrawerItem.this.checked);
                }
                return false;
            }
        });
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends BasePrimaryDrawerItem.BaseViewHolder {
        private ToggleButton toggle;

        private ViewHolder(View view) {
            super(view);
            this.toggle = (ToggleButton)view.findViewById(R.id.material_drawer_toggle);
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }
}

