/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialdrawer.model.interfaces.Typefaceable;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;
import com.mikepenz.materialize.util.UIUtils;

public class SectionDrawerItem
extends AbstractDrawerItem<SectionDrawerItem>
implements Nameable<SectionDrawerItem>,
Typefaceable<SectionDrawerItem> {
    private StringHolder name;
    private boolean divider = true;
    private ColorHolder textColor;
    private Typeface typeface = null;

    @Override
    public SectionDrawerItem withName(StringHolder name) {
        this.name = name;
        return this;
    }

    @Override
    public SectionDrawerItem withName(String name) {
        this.name = new StringHolder(name);
        return this;
    }

    @Override
    public SectionDrawerItem withName(@StringRes int nameRes) {
        this.name = new StringHolder(nameRes);
        return this;
    }

    public SectionDrawerItem withDivider(boolean divider) {
        this.divider = divider;
        return this;
    }

    public SectionDrawerItem withTextColor(int textColor) {
        this.textColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public SectionDrawerItem withTextColorRes(int textColorRes) {
        this.textColor = ColorHolder.fromColorRes(textColorRes);
        return this;
    }

    @Override
    public SectionDrawerItem withTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public boolean hasDivider() {
        return this.divider;
    }

    public ColorHolder getTextColor() {
        return this.textColor;
    }

    @Override
    public StringHolder getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public String getType() {
        return "SECTION_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_section;
    }

    @Override
    public Typeface getTypeface() {
        return this.typeface;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        Context ctx = holder.itemView.getContext();
        ViewHolder viewHolder = (ViewHolder)holder;
        holder.itemView.setId(this.getIdentifier());
        viewHolder.view.setClickable(false);
        viewHolder.view.setEnabled(false);
        viewHolder.name.setTextColor(ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getTextColor(), (Context)ctx, (int)R.attr.material_drawer_secondary_text, (int)R.color.material_drawer_secondary_text));
        StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        if (this.hasDivider()) {
            viewHolder.divider.setVisibility(0);
        } else {
            viewHolder.divider.setVisibility(8);
        }
        viewHolder.divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private View divider;
        private TextView name;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
            this.divider = view.findViewById(R.id.material_drawer_divider);
            this.name = (TextView)view.findViewById(R.id.material_drawer_name);
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }
}

