/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.CompoundButton;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.interfaces.OnCheckedChangeListener;
import com.mikepenz.materialdrawer.model.BaseSecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;

public class SecondarySwitchDrawerItem
extends BaseSecondaryDrawerItem<SecondarySwitchDrawerItem> {
    private boolean switchEnabled = true;
    private boolean checked = false;
    private OnCheckedChangeListener onCheckedChangeListener = null;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (SecondarySwitchDrawerItem.this.isEnabled()) {
                SecondarySwitchDrawerItem.this.checked = isChecked;
                if (SecondarySwitchDrawerItem.this.getOnCheckedChangeListener() != null) {
                    SecondarySwitchDrawerItem.this.getOnCheckedChangeListener().onCheckedChanged(SecondarySwitchDrawerItem.this, buttonView, isChecked);
                }
            } else {
                buttonView.setOnCheckedChangeListener(null);
                buttonView.setChecked(!isChecked);
                buttonView.setOnCheckedChangeListener(SecondarySwitchDrawerItem.this.checkedChangeListener);
            }
        }
    };

    public SecondarySwitchDrawerItem withChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public SecondarySwitchDrawerItem withSwitchEnabled(boolean switchEnabled) {
        this.switchEnabled = switchEnabled;
        return this;
    }

    public SecondarySwitchDrawerItem withOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
        return this;
    }

    public SecondarySwitchDrawerItem withCheckable(boolean checkable) {
        return (SecondarySwitchDrawerItem)this.withSelectable(checkable);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public OnCheckedChangeListener getOnCheckedChangeListener() {
        return this.onCheckedChangeListener;
    }

    @Override
    public String getType() {
        return "SECONDARY_SWITCH_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_secondary_switch;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        final ViewHolder viewHolder = (ViewHolder)holder;
        this.bindViewHelper((BaseSecondaryDrawerItem.BaseViewHolder)holder);
        viewHolder.switchView.setOnCheckedChangeListener(null);
        viewHolder.switchView.setChecked(this.checked);
        viewHolder.switchView.setOnCheckedChangeListener(this.checkedChangeListener);
        viewHolder.switchView.setEnabled(this.switchEnabled);
        this.withOnDrawerItemClickListener(new Drawer.OnDrawerItemClickListener(){

            @Override
            public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
                if (!SecondarySwitchDrawerItem.this.isSelectable()) {
                    SecondarySwitchDrawerItem.this.checked = !SecondarySwitchDrawerItem.this.checked;
                    viewHolder.switchView.setChecked(SecondarySwitchDrawerItem.this.checked);
                }
                return false;
            }
        });
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends BaseSecondaryDrawerItem.BaseViewHolder {
        private SwitchCompat switchView;

        private ViewHolder(View view) {
            super(view);
            this.switchView = (SwitchCompat)view.findViewById(R.id.material_drawer_switch);
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }
}

