/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.model.interfaces.Typefaceable;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.holder.ImageHolder;
import com.mikepenz.materialize.util.UIUtils;

public class ProfileDrawerItem
extends AbstractDrawerItem<ProfileDrawerItem>
implements IProfile<ProfileDrawerItem>,
Tagable<ProfileDrawerItem>,
Typefaceable<ProfileDrawerItem> {
    protected boolean nameShown = false;
    protected com.mikepenz.materialdrawer.holder.ImageHolder icon;
    protected StringHolder name;
    protected StringHolder email;
    protected ColorHolder selectedColor;
    protected ColorHolder textColor;
    protected Typeface typeface = null;

    @Override
    public ProfileDrawerItem withIcon(Drawable icon) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(@DrawableRes int iconRes) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(iconRes);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(Bitmap iconBitmap) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(iconBitmap);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(IIcon icon) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(String url) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(url);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(Uri uri) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(uri);
        return this;
    }

    @Override
    public ProfileDrawerItem withName(String name) {
        this.name = new StringHolder(name);
        return this;
    }

    @Override
    public ProfileDrawerItem withEmail(String email) {
        this.email = new StringHolder(email);
        return this;
    }

    public ProfileDrawerItem withNameShown(boolean nameShown) {
        this.nameShown = nameShown;
        return this;
    }

    public ProfileDrawerItem withSelectedColor(@ColorInt int selectedColor) {
        this.selectedColor = ColorHolder.fromColor(selectedColor);
        return this;
    }

    public ProfileDrawerItem withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.selectedColor = ColorHolder.fromColorRes(selectedColorRes);
        return this;
    }

    public ProfileDrawerItem withTextColor(@ColorInt int textColor) {
        this.textColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public ProfileDrawerItem withTextColorRes(@ColorRes int textColorRes) {
        this.textColor = ColorHolder.fromColorRes(textColorRes);
        return this;
    }

    @Override
    public ProfileDrawerItem withTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public boolean isNameShown() {
        return this.nameShown;
    }

    public void setNameShown(boolean nameShown) {
        this.nameShown = nameShown;
    }

    public ColorHolder getSelectedColor() {
        return this.selectedColor;
    }

    public ColorHolder getTextColor() {
        return this.textColor;
    }

    @Override
    public Typeface getTypeface() {
        return this.typeface;
    }

    @Override
    public com.mikepenz.materialdrawer.holder.ImageHolder getIcon() {
        return this.icon;
    }

    @Override
    public StringHolder getName() {
        return this.name;
    }

    @Override
    public StringHolder getEmail() {
        return this.email;
    }

    @Override
    public String getType() {
        return "PROFILE_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_profile;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        Context ctx = holder.itemView.getContext();
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.itemView.setId(this.getIdentifier());
        viewHolder.itemView.setSelected(this.isSelected());
        int selectedColor = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
        int color2 = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getTextColor(), (Context)ctx, (int)R.attr.material_drawer_primary_text, (int)R.color.material_drawer_primary_text);
        UIUtils.setBackground((View)viewHolder.view, (Drawable)DrawerUIUtils.getSelectableBackground(ctx, selectedColor));
        if (this.nameShown) {
            viewHolder.name.setVisibility(0);
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        } else {
            viewHolder.name.setVisibility(8);
        }
        if (!this.nameShown && this.getEmail() == null && this.getName() != null) {
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.email);
        } else {
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getEmail(), (TextView)viewHolder.email);
        }
        if (this.getTypeface() != null) {
            viewHolder.name.setTypeface(this.getTypeface());
            viewHolder.email.setTypeface(this.getTypeface());
        }
        if (this.nameShown) {
            viewHolder.name.setTextColor(color2);
        }
        viewHolder.email.setTextColor(color2);
        DrawerImageLoader.getInstance().cancelImage(viewHolder.profileIcon);
        com.mikepenz.materialdrawer.holder.ImageHolder.applyToOrSetInvisible((ImageHolder)this.getIcon(), (ImageView)viewHolder.profileIcon, (String)DrawerImageLoader.Tags.PROFILE_DRAWER_ITEM.name());
        DrawerUIUtils.setDrawerVerticalPadding(viewHolder.view);
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private ImageView profileIcon;
        private TextView name;
        private TextView email;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
            this.profileIcon = (ImageView)view.findViewById(R.id.material_drawer_profileIcon);
            this.name = (TextView)view.findViewById(R.id.material_drawer_name);
            this.email = (TextView)view.findViewById(R.id.material_drawer_email);
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }
}

