/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;

public class MiniDrawerItem
extends BaseDrawerItem<MiniDrawerItem> {
    private StringHolder mBadge;
    private BadgeStyle mBadgeStyle = new BadgeStyle();
    private boolean mEnableSelectedBackground = false;

    public MiniDrawerItem() {
    }

    public MiniDrawerItem(PrimaryDrawerItem primaryDrawerItem) {
        this.mIdentifier = primaryDrawerItem.mIdentifier;
        this.mTag = primaryDrawerItem.mTag;
        this.mBadge = primaryDrawerItem.mBadge;
        this.mBadgeStyle = primaryDrawerItem.mBadgeStyle;
        this.mEnabled = primaryDrawerItem.mEnabled;
        this.mSelectable = primaryDrawerItem.mSelectable;
        this.mSelected = primaryDrawerItem.mSelected;
        this.icon = primaryDrawerItem.icon;
        this.selectedIcon = primaryDrawerItem.selectedIcon;
        this.iconTinted = primaryDrawerItem.iconTinted;
        this.selectedColor = primaryDrawerItem.selectedColor;
        this.iconColor = primaryDrawerItem.iconColor;
        this.selectedIconColor = primaryDrawerItem.selectedIconColor;
        this.disabledIconColor = primaryDrawerItem.disabledIconColor;
    }

    public MiniDrawerItem(SecondaryDrawerItem secondaryDrawerItem) {
        this.mIdentifier = secondaryDrawerItem.mIdentifier;
        this.mTag = secondaryDrawerItem.mTag;
        this.mBadge = secondaryDrawerItem.mBadge;
        this.mBadgeStyle = secondaryDrawerItem.mBadgeStyle;
        this.mEnabled = secondaryDrawerItem.mEnabled;
        this.mSelectable = secondaryDrawerItem.mSelectable;
        this.mSelected = secondaryDrawerItem.mSelected;
        this.icon = secondaryDrawerItem.icon;
        this.selectedIcon = secondaryDrawerItem.selectedIcon;
        this.iconTinted = secondaryDrawerItem.iconTinted;
        this.selectedColor = secondaryDrawerItem.selectedColor;
        this.iconColor = secondaryDrawerItem.iconColor;
        this.selectedIconColor = secondaryDrawerItem.selectedIconColor;
        this.disabledIconColor = secondaryDrawerItem.disabledIconColor;
    }

    public MiniDrawerItem withEnableSelectedBackground(boolean enableSelectedBackground) {
        this.mEnableSelectedBackground = enableSelectedBackground;
        return this;
    }

    @Override
    public String getType() {
        return "MINI_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_mini;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        boolean badgeVisible;
        Context ctx = holder.itemView.getContext();
        ViewHolder viewHolder = (ViewHolder)holder;
        viewHolder.itemView.setId(this.getIdentifier());
        viewHolder.itemView.setSelected(this.isSelected());
        viewHolder.itemView.setTag((Object)this);
        int iconColor = this.getIconColor(ctx);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        if (this.mEnableSelectedBackground) {
            int selectedColor = this.getSelectedColor(ctx);
            UIUtils.setBackground((View)viewHolder.view, (Drawable)DrawerUIUtils.getSelectableBackground(ctx, selectedColor));
        }
        if (badgeVisible = StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.mBadge, (TextView)viewHolder.badge)) {
            this.mBadgeStyle.style(viewHolder.badge);
        }
        Drawable icon = ImageHolder.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
        Drawable selectedIcon = ImageHolder.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
        ImageHolder.applyMultiIconTo((Drawable)icon, (int)iconColor, (Drawable)selectedIcon, (int)selectedIconColor, (boolean)this.isIconTinted(), (ImageView)viewHolder.icon);
        int verticalPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
        int topBottomPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_mini_drawer_item_padding);
        viewHolder.itemView.setPadding(verticalPadding, topBottomPadding, verticalPadding, topBottomPadding);
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private ImageView icon;
        private TextView badge;

        public ViewHolder(View view) {
            super(view);
            this.view = view;
            this.icon = (ImageView)view.findViewById(R.id.material_drawer_icon);
            this.badge = (TextView)view.findViewById(R.id.material_drawer_badge);
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }
}

