/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;
import com.mikepenz.materialize.util.UIUtils;

public class ContainerDrawerItem
extends AbstractDrawerItem<ContainerDrawerItem> {
    private View mView;
    private Position mViewPosition = Position.TOP;
    private boolean mDivider = true;

    public ContainerDrawerItem withView(View view) {
        this.mView = view;
        return this;
    }

    public View getView() {
        return this.mView;
    }

    public ContainerDrawerItem withViewPosition(Position position) {
        this.mViewPosition = position;
        return this;
    }

    public ContainerDrawerItem withDivider(boolean divider) {
        this.mDivider = divider;
        return this;
    }

    public Position getViewPosition() {
        return this.mViewPosition;
    }

    @Override
    public String getType() {
        return "CONTAINER_ITEM";
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_container;
    }

    @Override
    public void bindView(RecyclerView.ViewHolder holder) {
        Context ctx = holder.itemView.getContext();
        ViewHolder viewHolder = (ViewHolder)holder;
        holder.itemView.setId(this.getIdentifier());
        viewHolder.view.setEnabled(false);
        if (this.mView.getParent() != null) {
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
        }
        ((ViewGroup)viewHolder.view).removeAllViews();
        int dividerHeight = 0;
        if (this.mDivider) {
            dividerHeight = 1;
        }
        View divider = new View(ctx);
        divider.setMinimumHeight(dividerHeight);
        divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, (int)UIUtils.convertDpToPixel((float)dividerHeight, (Context)ctx));
        if (this.mViewPosition == Position.TOP) {
            ((ViewGroup)viewHolder.view).addView(this.mView, -1, -2);
            layoutParams.bottomMargin = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
            ((ViewGroup)viewHolder.view).addView(divider, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.mViewPosition == Position.BOTTOM) {
            layoutParams.topMargin = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
            ((ViewGroup)viewHolder.view).addView(divider, (ViewGroup.LayoutParams)layoutParams);
            ((ViewGroup)viewHolder.view).addView(this.mView);
        } else {
            ((ViewGroup)viewHolder.view).addView(this.mView);
        }
        this.onPostBindView(this, holder.itemView);
    }

    @Override
    public ViewHolderFactory getFactory() {
        return new ItemFactory();
    }

    private static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
        }
    }

    public static class ItemFactory
    implements ViewHolderFactory<ViewHolder> {
        @Override
        public ViewHolder factory(View v) {
            return new ViewHolder(v);
        }
    }

    public static enum Position {
        TOP,
        BOTTOM,
        NONE;

    }
}

