/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;

public abstract class BasePrimaryDrawerItem<T>
extends BaseDrawerItem<T> {
    private StringHolder description;
    private ColorHolder descriptionTextColor;

    public T withDescription(String description) {
        this.description = new StringHolder(description);
        return (T)this;
    }

    public T withDescription(@StringRes int descriptionRes) {
        this.description = new StringHolder(descriptionRes);
        return (T)this;
    }

    public T withDescriptionTextColor(@ColorInt int color2) {
        this.descriptionTextColor = ColorHolder.fromColor(color2);
        return (T)this;
    }

    public T withDescriptionTextColorRes(@ColorRes int colorRes) {
        this.descriptionTextColor = ColorHolder.fromColorRes(colorRes);
        return (T)this;
    }

    public StringHolder getDescription() {
        return this.description;
    }

    public ColorHolder getDescriptionTextColor() {
        return this.descriptionTextColor;
    }

    protected void bindViewHelper(BaseViewHolder viewHolder) {
        Context ctx = viewHolder.itemView.getContext();
        viewHolder.itemView.setId(this.getIdentifier());
        viewHolder.itemView.setSelected(this.isSelected());
        viewHolder.itemView.setTag((Object)this);
        int selectedColor = this.getSelectedColor(ctx);
        int color2 = this.getColor(ctx);
        int selectedTextColor = this.getSelectedTextColor(ctx);
        int iconColor = this.getIconColor(ctx);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        UIUtils.setBackground((View)viewHolder.view, (Drawable)DrawerUIUtils.getSelectableBackground(ctx, selectedColor));
        StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.getDescription(), (TextView)viewHolder.description);
        viewHolder.name.setTextColor(this.getTextColorStateList(color2, selectedTextColor));
        ColorHolder.applyToOr((com.mikepenz.materialize.holder.ColorHolder)this.getDescriptionTextColor(), (TextView)viewHolder.description, (ColorStateList)this.getTextColorStateList(color2, selectedTextColor));
        if (this.getTypeface() != null) {
            viewHolder.name.setTypeface(this.getTypeface());
            viewHolder.description.setTypeface(this.getTypeface());
        }
        Drawable icon = ImageHolder.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
        Drawable selectedIcon = ImageHolder.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
        ImageHolder.applyMultiIconTo((Drawable)icon, (int)iconColor, (Drawable)selectedIcon, (int)selectedIconColor, (boolean)this.isIconTinted(), (ImageView)viewHolder.icon);
        DrawerUIUtils.setDrawerVerticalPadding(viewHolder.view, this.level);
    }

    protected static class BaseViewHolder
    extends RecyclerView.ViewHolder {
        protected View view;
        protected ImageView icon;
        protected TextView name;
        protected TextView description;

        public BaseViewHolder(View view) {
            super(view);
            this.view = view;
            this.icon = (ImageView)view.findViewById(R.id.material_drawer_icon);
            this.name = (TextView)view.findViewById(R.id.material_drawer_name);
            this.description = (TextView)view.findViewById(R.id.material_drawer_description);
        }
    }
}

