/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.util.Pair;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Iconable;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.model.interfaces.Typefaceable;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;

public abstract class BaseDrawerItem<T>
extends AbstractDrawerItem<T>
implements Nameable<T>,
Iconable<T>,
Tagable<T>,
Typefaceable<T> {
    protected ImageHolder icon;
    protected ImageHolder selectedIcon;
    protected StringHolder name;
    protected boolean iconTinted = false;
    protected ColorHolder selectedColor;
    protected ColorHolder textColor;
    protected ColorHolder selectedTextColor;
    protected ColorHolder disabledTextColor;
    protected ColorHolder iconColor;
    protected ColorHolder selectedIconColor;
    protected ColorHolder disabledIconColor;
    protected Typeface typeface = null;
    protected Pair<Integer, ColorStateList> colorStateList;
    protected int level = 1;

    @Override
    public T withIcon(ImageHolder icon) {
        this.icon = icon;
        return (T)this;
    }

    @Override
    public T withIcon(Drawable icon) {
        this.icon = new ImageHolder(icon);
        return (T)this;
    }

    public T withIcon(@DrawableRes int iconRes) {
        this.icon = new ImageHolder(iconRes);
        return (T)this;
    }

    public T withSelectedIcon(Drawable selectedIcon) {
        this.selectedIcon = new ImageHolder(selectedIcon);
        return (T)this;
    }

    public T withSelectedIcon(@DrawableRes int selectedIconRes) {
        this.selectedIcon = new ImageHolder(selectedIconRes);
        return (T)this;
    }

    @Override
    public T withIcon(IIcon iicon) {
        this.icon = new ImageHolder(iicon);
        if (Build.VERSION.SDK_INT >= 21) {
            this.selectedIcon = new ImageHolder(iicon);
        } else {
            this.withIconTintingEnabled(true);
        }
        return (T)this;
    }

    @Override
    public T withName(StringHolder name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public T withName(String name) {
        this.name = new StringHolder(name);
        return (T)this;
    }

    @Override
    public T withName(@StringRes int nameRes) {
        this.name = new StringHolder(nameRes);
        return (T)this;
    }

    public T withSelectedColor(@ColorInt int selectedColor) {
        this.selectedColor = ColorHolder.fromColor(selectedColor);
        return (T)this;
    }

    public T withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.selectedColor = ColorHolder.fromColorRes(selectedColorRes);
        return (T)this;
    }

    public T withTextColor(@ColorInt int textColor) {
        this.textColor = ColorHolder.fromColor(textColor);
        return (T)this;
    }

    public T withTextColorRes(@ColorRes int textColorRes) {
        this.textColor = ColorHolder.fromColorRes(textColorRes);
        return (T)this;
    }

    public T withSelectedTextColor(@ColorInt int selectedTextColor) {
        this.selectedTextColor = ColorHolder.fromColor(selectedTextColor);
        return (T)this;
    }

    public T withSelectedTextColorRes(@ColorRes int selectedColorRes) {
        this.selectedTextColor = ColorHolder.fromColorRes(selectedColorRes);
        return (T)this;
    }

    public T withDisabledTextColor(@ColorInt int disabledTextColor) {
        this.disabledTextColor = ColorHolder.fromColor(disabledTextColor);
        return (T)this;
    }

    public T withDisabledTextColorRes(@ColorRes int disabledTextColorRes) {
        this.disabledTextColor = ColorHolder.fromColorRes(disabledTextColorRes);
        return (T)this;
    }

    public T withIconColor(@ColorInt int iconColor) {
        this.iconColor = ColorHolder.fromColor(iconColor);
        return (T)this;
    }

    public T withIconColorRes(@ColorRes int iconColorRes) {
        this.iconColor = ColorHolder.fromColorRes(iconColorRes);
        return (T)this;
    }

    public T withSelectedIconColor(@ColorInt int selectedIconColor) {
        this.selectedIconColor = ColorHolder.fromColor(selectedIconColor);
        return (T)this;
    }

    public T withSelectedIconColorRes(@ColorRes int selectedColorRes) {
        this.selectedIconColor = ColorHolder.fromColorRes(selectedColorRes);
        return (T)this;
    }

    public T withDisabledIconColor(@ColorInt int disabledIconColor) {
        this.disabledIconColor = ColorHolder.fromColor(disabledIconColor);
        return (T)this;
    }

    public T withDisabledIconColorRes(@ColorRes int disabledIconColorRes) {
        this.disabledIconColor = ColorHolder.fromColorRes(disabledIconColorRes);
        return (T)this;
    }

    public T withIconTintingEnabled(boolean iconTintingEnabled) {
        this.iconTinted = iconTintingEnabled;
        return (T)this;
    }

    @Deprecated
    public T withIconTinted(boolean iconTinted) {
        this.iconTinted = iconTinted;
        return (T)this;
    }

    @Deprecated
    public T withTintSelectedIcon(boolean iconTinted) {
        return this.withIconTintingEnabled(iconTinted);
    }

    @Override
    public T withTypeface(Typeface typeface) {
        this.typeface = typeface;
        return (T)this;
    }

    public T withLevel(int level) {
        this.level = level;
        return (T)this;
    }

    public ColorHolder getSelectedColor() {
        return this.selectedColor;
    }

    public ColorHolder getTextColor() {
        return this.textColor;
    }

    public ColorHolder getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public ColorHolder getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public boolean isIconTinted() {
        return this.iconTinted;
    }

    @Override
    public ImageHolder getIcon() {
        return this.icon;
    }

    public ImageHolder getSelectedIcon() {
        return this.selectedIcon;
    }

    @Override
    public StringHolder getName() {
        return this.name;
    }

    public ColorHolder getDisabledIconColor() {
        return this.disabledIconColor;
    }

    public ColorHolder getSelectedIconColor() {
        return this.selectedIconColor;
    }

    public ColorHolder getIconColor() {
        return this.iconColor;
    }

    @Override
    public Typeface getTypeface() {
        return this.typeface;
    }

    public int getLevel() {
        return this.level;
    }

    protected int getSelectedColor(Context ctx) {
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
    }

    protected int getColor(Context ctx) {
        int color2 = this.isEnabled() ? ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getTextColor(), (Context)ctx, (int)R.attr.material_drawer_primary_text, (int)R.color.material_drawer_primary_text) : ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getDisabledTextColor(), (Context)ctx, (int)R.attr.material_drawer_hint_text, (int)R.color.material_drawer_hint_text);
        return color2;
    }

    protected int getSelectedTextColor(Context ctx) {
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedTextColor(), (Context)ctx, (int)R.attr.material_drawer_selected_text, (int)R.color.material_drawer_selected_text);
    }

    public int getIconColor(Context ctx) {
        int iconColor = this.isEnabled() ? ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getIconColor(), (Context)ctx, (int)R.attr.material_drawer_primary_icon, (int)R.color.material_drawer_primary_icon) : ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getDisabledIconColor(), (Context)ctx, (int)R.attr.material_drawer_hint_icon, (int)R.color.material_drawer_hint_icon);
        return iconColor;
    }

    protected int getSelectedIconColor(Context ctx) {
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedIconColor(), (Context)ctx, (int)R.attr.material_drawer_selected_text, (int)R.color.material_drawer_selected_text);
    }

    protected ColorStateList getTextColorStateList(@ColorInt int color2, @ColorInt int selectedTextColor) {
        if (this.colorStateList == null || color2 + selectedTextColor != (Integer)this.colorStateList.first) {
            this.colorStateList = new Pair((Object)(color2 + selectedTextColor), (Object)DrawerUIUtils.getTextColorStateList(color2, selectedTextColor));
        }
        return (ColorStateList)this.colorStateList.second;
    }
}

