/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.OnPostBindViewListener;
import com.mikepenz.materialdrawer.model.interfaces.Selectable;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.model.utils.ViewHolderFactory;

public abstract class AbstractDrawerItem<T>
implements IDrawerItem<T>,
Selectable<T>,
Tagable<T> {
    protected int mIdentifier = -1;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;
    public Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener = null;
    protected OnPostBindViewListener mOnPostBindViewListener = null;

    @Override
    public T withIdentifier(int identifier) {
        this.mIdentifier = identifier;
        return (T)this;
    }

    @Override
    public int getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public T withTag(Object object) {
        this.mTag = object;
        return (T)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    public T withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (T)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public T withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (T)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public T withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (T)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mOnDrawerItemClickListener;
    }

    public T withOnDrawerItemClickListener(Drawer.OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener;
        return (T)this;
    }

    public OnPostBindViewListener getOnPostBindViewListener() {
        return this.mOnPostBindViewListener;
    }

    public T withPostOnBindViewListener(OnPostBindViewListener onPostBindViewListener) {
        this.mOnPostBindViewListener = onPostBindViewListener;
        return (T)this;
    }

    public void onPostBindView(IDrawerItem drawerItem, View view) {
        if (this.mOnPostBindViewListener != null) {
            this.mOnPostBindViewListener.onBindView(drawerItem, view);
        }
    }

    public abstract ViewHolderFactory getFactory();

    @Override
    public View generateView(Context ctx) {
        Object viewHolder = this.getFactory().factory(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), null, false));
        this.bindView((RecyclerView.ViewHolder)viewHolder);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        Object viewHolder = this.getFactory().factory(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false));
        this.bindView((RecyclerView.ViewHolder)viewHolder);
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public RecyclerView.ViewHolder getViewHolder(ViewGroup parent) {
        return this.getFactory().factory(LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutRes(), parent, false));
    }

    @Override
    public boolean equals(Integer id2) {
        return id2 != null && id2 == this.mIdentifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDrawerItem that = (AbstractDrawerItem)o;
        return this.mIdentifier == that.mIdentifier;
    }

    public int hashCode() {
        return this.mIdentifier;
    }
}

