/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Selectable;
import com.mikepenz.materialdrawer.util.RecyclerViewCacheUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseDrawerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private ArrayList<IDrawerItem> mHeaderDrawerItems = new ArrayList();
    private ArrayList<IDrawerItem> mDrawerItems = new ArrayList();
    private ArrayList<IDrawerItem> mFooterDrawerItems = new ArrayList();
    private LinkedList<String> mTypeIds = new LinkedList();
    private LinkedHashMap<String, IDrawerItem> mTypeInstances = new LinkedHashMap();
    private int previousSelection = -1;
    private OnClickListener mOnClickListener;
    private OnLongClickListener mOnLongClickListener;

    public BaseDrawerAdapter() {
    }

    public BaseDrawerAdapter(ArrayList<IDrawerItem> drawerItems) {
        this.setDrawerItems(drawerItems);
    }

    public void setOnClickListener(OnClickListener mOnClickListener) {
        this.mOnClickListener = mOnClickListener;
    }

    public void setOnLongClickListener(OnLongClickListener mOnLongClickListener) {
        this.mOnLongClickListener = mOnLongClickListener;
    }

    public ArrayList<IDrawerItem> getDrawerItems() {
        return this.mDrawerItems;
    }

    public void setDrawerItems(ArrayList<IDrawerItem> drawerItems) {
        this.mDrawerItems = drawerItems;
        this.mapPossibleTypes(drawerItems);
        this.notifyItemRangeChanged(this.getHeaderItemCount(), this.getDrawerItemCount());
    }

    public void addDrawerItems(IDrawerItem ... drawerItems) {
        int length = this.mDrawerItems.size();
        if (drawerItems != null) {
            Collections.addAll(this.mDrawerItems, drawerItems);
            this.mapPossibleTypes(this.mDrawerItems);
            this.notifyItemRangeInserted(length, drawerItems.length);
        }
    }

    public void addDrawerItems(int position, IDrawerItem ... drawerItems) {
        if (drawerItems != null) {
            this.mDrawerItems.addAll(position, Arrays.asList(drawerItems));
            this.mapPossibleTypes(this.mDrawerItems);
            this.notifyItemRangeInserted(position + 1, drawerItems.length);
            if (position < this.previousSelection) {
                this.previousSelection += drawerItems.length;
            }
        }
    }

    public void setDrawerItem(int position, IDrawerItem drawerItem) {
        this.mDrawerItems.set(position - this.getHeaderItemCount(), drawerItem);
        this.mapPossibleType(drawerItem);
        this.notifyItemChanged(position);
    }

    public void addDrawerItem(IDrawerItem drawerItem) {
        this.mDrawerItems.add(drawerItem);
        this.mapPossibleType(drawerItem);
        this.notifyItemInserted(this.mDrawerItems.size());
    }

    public void addDrawerItem(int position, IDrawerItem drawerItem) {
        this.mDrawerItems.add(position - this.getHeaderItemCount(), drawerItem);
        this.mapPossibleType(drawerItem);
        this.notifyItemInserted(position);
        if (position < this.previousSelection) {
            ++this.previousSelection;
        }
    }

    public void removeDrawerItem(int position) {
        this.mDrawerItems.remove(position - this.getHeaderItemCount());
        this.notifyItemRemoved(position);
        if (position < this.previousSelection) {
            --this.previousSelection;
        }
    }

    public void clearDrawerItems() {
        int count = this.mDrawerItems.size();
        this.mDrawerItems.clear();
        this.notifyItemRangeRemoved(this.getHeaderItemCount(), count);
        this.previousSelection = -1;
    }

    public void clearHeaderItems() {
        int size = this.mHeaderDrawerItems.size();
        this.mHeaderDrawerItems.clear();
        if (size > 0) {
            this.notifyItemRemoved(0);
        }
    }

    public void clearFooterItems() {
        int count = this.mFooterDrawerItems.size();
        this.mFooterDrawerItems.clear();
        this.notifyItemRangeRemoved(this.getHeaderItemCount() + this.getDrawerItemCount(), count);
    }

    public ArrayList<IDrawerItem> getHeaderDrawerItems() {
        return this.mHeaderDrawerItems;
    }

    public void setHeaderDrawerItems(ArrayList<IDrawerItem> mHeaderDrawerItems) {
        this.mHeaderDrawerItems = mHeaderDrawerItems;
        this.notifyItemRangeInserted(0, mHeaderDrawerItems.size());
        this.mapPossibleTypes(mHeaderDrawerItems);
    }

    public void addHeaderDrawerItems(IDrawerItem ... drawerItems) {
        if (drawerItems != null) {
            Collections.addAll(this.mHeaderDrawerItems, drawerItems);
            this.notifyItemRangeInserted(0, drawerItems.length);
        }
        this.mapPossibleTypes(this.mHeaderDrawerItems);
    }

    public ArrayList<IDrawerItem> getFooterDrawerItems() {
        return this.mFooterDrawerItems;
    }

    public void setFooterDrawerItems(ArrayList<IDrawerItem> mFooterDrawerItems) {
        this.mFooterDrawerItems = mFooterDrawerItems;
        this.notifyItemRangeInserted(0, mFooterDrawerItems.size());
        this.mapPossibleTypes(mFooterDrawerItems);
    }

    public void addFooterDrawerItems(IDrawerItem ... drawerItems) {
        if (drawerItems != null) {
            Collections.addAll(this.mFooterDrawerItems, drawerItems);
            this.notifyItemRangeInserted(0, drawerItems.length);
        }
        this.mapPossibleTypes(this.mFooterDrawerItems);
    }

    private void mapPossibleTypes(List<IDrawerItem> drawerItemList) {
        if (drawerItemList != null) {
            for (IDrawerItem drawerItem : drawerItemList) {
                this.mapPossibleType(drawerItem);
            }
        }
    }

    private void mapPossibleType(IDrawerItem drawerItem) {
        if (!this.mTypeInstances.containsKey(drawerItem.getType())) {
            this.mTypeIds.add(drawerItem.getType());
            this.mTypeInstances.put(drawerItem.getType(), drawerItem);
        }
    }

    public int getItemViewType(int position) {
        return this.mTypeIds.indexOf(this.getItem(position).getType());
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder vh = RecyclerViewCacheUtil.getInstance().obtain(this.mTypeIds.get(viewType));
        if (vh == null) {
            return this.mTypeInstances.get(this.mTypeIds.get(viewType)).getViewHolder(parent);
        }
        return vh;
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        this.getItem(position).bindView(holder);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = holder.getAdapterPosition();
                IDrawerItem drawerItem = BaseDrawerAdapter.this.getItem(pos);
                if (drawerItem != null && drawerItem.isEnabled()) {
                    AbstractDrawerItem adi;
                    if (drawerItem instanceof Selectable && drawerItem.isSelectable()) {
                        BaseDrawerAdapter.this.handleSelection(v, pos);
                    }
                    if (BaseDrawerAdapter.this.mOnClickListener != null) {
                        BaseDrawerAdapter.this.mOnClickListener.onClick(v, pos, drawerItem);
                    }
                    if (drawerItem instanceof AbstractDrawerItem && (adi = (AbstractDrawerItem)drawerItem).getOnDrawerItemClickListener() != null) {
                        adi.getOnDrawerItemClickListener().onItemClick(v, pos, drawerItem);
                    }
                }
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (BaseDrawerAdapter.this.mOnLongClickListener != null) {
                    int pos = holder.getAdapterPosition();
                    return BaseDrawerAdapter.this.mOnLongClickListener.onLongClick(v, pos, BaseDrawerAdapter.this.getItem(pos));
                }
                return false;
            }
        });
    }

    public void handleSelection(View v, int pos) {
        if (this.previousSelection > -1) {
            IDrawerItem prev = this.getItem(this.previousSelection);
            if (prev != null) {
                prev.withSetSelected(false);
            }
            this.notifyItemChanged(this.previousSelection);
        } else {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getItem(i).isSelected()) continue;
                this.getItem(i).withSetSelected(false);
                this.notifyItemChanged(i);
                break;
            }
        }
        if (pos > -1) {
            IDrawerItem cur = this.getItem(pos);
            if (cur != null) {
                cur.withSetSelected(true);
            }
            this.notifyItemChanged(pos);
            if (v != null) {
                v.setSelected(true);
                v.invalidate();
            }
        }
        this.previousSelection = pos;
    }

    public boolean isEnabled(int position) {
        IDrawerItem item = this.getItem(position);
        return item != null && item.isEnabled();
    }

    public boolean isSelected(int position) {
        IDrawerItem item = this.getItem(position);
        return item != null && item.isSelected();
    }

    public IDrawerItem getItem(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return null;
        }
        if (position < this.getHeaderItemCount()) {
            return this.mHeaderDrawerItems.get(position);
        }
        if (position < this.getHeaderItemCount() + this.getDrawerItemCount()) {
            return this.mDrawerItems.get(position - this.getHeaderItemCount());
        }
        return this.mFooterDrawerItems.get(position - this.getHeaderItemCount() - this.getDrawerItemCount());
    }

    public long getItemId(int position) {
        IDrawerItem item = this.getItem(position);
        if (item != null && item.getIdentifier() != -1) {
            return item.getIdentifier();
        }
        return super.getItemId(position);
    }

    public int getItemCount() {
        int itemCount = 0;
        itemCount += this.getHeaderItemCount();
        itemCount += this.getDrawerItemCount();
        return itemCount += this.getFooterItemCount();
    }

    public int getHeaderOffset() {
        return this.getHeaderItemCount();
    }

    protected int getHeaderItemCount() {
        return this.mHeaderDrawerItems == null ? 0 : this.mHeaderDrawerItems.size();
    }

    protected int getDrawerItemCount() {
        return this.mDrawerItems == null ? 0 : this.mDrawerItems.size();
    }

    protected int getFooterItemCount() {
        return this.mFooterDrawerItems == null ? 0 : this.mFooterDrawerItems.size();
    }

    public static interface OnLongClickListener {
        public boolean onLongClick(View var1, int var2, IDrawerItem var3);
    }

    public static interface OnClickListener {
        public void onClick(View var1, int var2, IDrawerItem var3);
    }
}

