/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.LinearLayout;
import com.mikepenz.materialdrawer.AccountHeader;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.DrawerUtils;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.adapter.BaseDrawerAdapter;
import com.mikepenz.materialdrawer.adapter.DrawerAdapter;
import com.mikepenz.materialdrawer.interfaces.ICrossfader;
import com.mikepenz.materialdrawer.model.MiniDrawerItem;
import com.mikepenz.materialdrawer.model.MiniProfileDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.ProfileDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialize.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class MiniDrawer {
    public static final int PROFILE = 1;
    public static final int ITEM = 2;
    private LinearLayout mContainer;
    private RecyclerView mRecyclerView;
    private DrawerAdapter mDrawerAdapter;
    private Drawer mDrawer;
    private AccountHeader mAccountHeader;
    private ICrossfader mCrossFader;
    private boolean mInnerShadow = false;
    private boolean mInRTL = false;
    private boolean mIncludeSecondaryDrawerItems = false;
    private boolean mEnableSelectedMiniDrawerItemBackground = false;
    private boolean mEnableProfileClick = true;
    private BaseDrawerAdapter.OnClickListener mOnMiniDrawerItemClickListener;
    private BaseDrawerAdapter.OnLongClickListener mOnMiniDrawerItemLongClickListener;

    public MiniDrawer withDrawer(@NonNull Drawer drawer) {
        this.mDrawer = drawer;
        return this;
    }

    public MiniDrawer withAccountHeader(@NonNull AccountHeader accountHeader) {
        this.mAccountHeader = accountHeader;
        return this;
    }

    public MiniDrawer withCrossFader(@NonNull ICrossfader crossFader) {
        this.mCrossFader = crossFader;
        return this;
    }

    public MiniDrawer withInnerShadow(boolean innerShadow) {
        this.mInnerShadow = innerShadow;
        return this;
    }

    public MiniDrawer withInRTL(boolean inRTL) {
        this.mInRTL = inRTL;
        return this;
    }

    public MiniDrawer withIncludeSecondaryDrawerItems(boolean includeSecondaryDrawerItems) {
        this.mIncludeSecondaryDrawerItems = includeSecondaryDrawerItems;
        return this;
    }

    public MiniDrawer withEnableSelectedMiniDrawerItemBackground(boolean enableSelectedMiniDrawerItemBackground) {
        this.mEnableSelectedMiniDrawerItemBackground = enableSelectedMiniDrawerItemBackground;
        return this;
    }

    public MiniDrawer withEnableProfileClick(boolean enableProfileClick) {
        this.mEnableProfileClick = enableProfileClick;
        return this;
    }

    public MiniDrawer withOnMiniDrawerItemClickListener(BaseDrawerAdapter.OnClickListener onMiniDrawerItemClickListener) {
        this.mOnMiniDrawerItemClickListener = onMiniDrawerItemClickListener;
        return this;
    }

    public MiniDrawer withOnMiniDrawerItemLongClickListener(BaseDrawerAdapter.OnLongClickListener onMiniDrawerItemLongClickListener) {
        this.mOnMiniDrawerItemLongClickListener = onMiniDrawerItemLongClickListener;
        return this;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public DrawerAdapter getDrawerAdapter() {
        return this.mDrawerAdapter;
    }

    public Drawer getDrawer() {
        return this.mDrawer;
    }

    public AccountHeader getAccountHeader() {
        return this.mAccountHeader;
    }

    public ICrossfader getCrossFader() {
        return this.mCrossFader;
    }

    public BaseDrawerAdapter.OnClickListener getOnMiniDrawerItemClickListener() {
        return this.mOnMiniDrawerItemClickListener;
    }

    public BaseDrawerAdapter.OnLongClickListener getOnMiniDrawerItemLongClickListener() {
        return this.mOnMiniDrawerItemLongClickListener;
    }

    public IDrawerItem generateMiniDrawerItem(IDrawerItem drawerItem) {
        if (drawerItem instanceof PrimaryDrawerItem) {
            return new MiniDrawerItem((PrimaryDrawerItem)drawerItem).withEnableSelectedBackground(this.mEnableSelectedMiniDrawerItemBackground);
        }
        if (drawerItem instanceof SecondaryDrawerItem && this.mIncludeSecondaryDrawerItems) {
            return new MiniDrawerItem((SecondaryDrawerItem)drawerItem).withEnableSelectedBackground(this.mEnableSelectedMiniDrawerItemBackground);
        }
        if (drawerItem instanceof ProfileDrawerItem) {
            MiniProfileDrawerItem mpdi = new MiniProfileDrawerItem((ProfileDrawerItem)drawerItem);
            mpdi.withEnabled(this.mEnableProfileClick);
            return mpdi;
        }
        return null;
    }

    public int getMiniDrawerType(IDrawerItem drawerItem) {
        if (drawerItem instanceof MiniProfileDrawerItem) {
            return 1;
        }
        if (drawerItem instanceof MiniDrawerItem) {
            return 2;
        }
        return -1;
    }

    public View build(Context ctx) {
        this.mContainer = new LinearLayout(ctx);
        if (this.mInnerShadow) {
            if (!this.mInRTL) {
                this.mContainer.setBackgroundResource(R.drawable.material_drawer_shadow_left);
            } else {
                this.mContainer.setBackgroundResource(R.drawable.material_drawer_shadow_right);
            }
        }
        this.mRecyclerView = new RecyclerView(ctx);
        this.mContainer.addView((View)this.mRecyclerView, -1, -1);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mRecyclerView.setFadingEdgeLength(0);
        this.mRecyclerView.setClipToPadding(false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(ctx));
        this.mDrawerAdapter = new DrawerAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mDrawerAdapter);
        if (this.mDrawer != null && this.mDrawer.mDrawerBuilder != null && (this.mDrawer.mDrawerBuilder.mFullscreen || this.mDrawer.mDrawerBuilder.mTranslucentStatusBar)) {
            this.mRecyclerView.setPadding(this.mRecyclerView.getPaddingLeft(), UIUtils.getStatusBarHeight((Context)ctx), this.mRecyclerView.getPaddingRight(), this.mRecyclerView.getPaddingBottom());
        }
        if (this.mDrawer != null && this.mDrawer.mDrawerBuilder != null && (this.mDrawer.mDrawerBuilder.mFullscreen || this.mDrawer.mDrawerBuilder.mTranslucentNavigationBar)) {
            this.mRecyclerView.setPadding(this.mRecyclerView.getPaddingLeft(), this.mRecyclerView.getPaddingTop(), this.mRecyclerView.getPaddingRight(), UIUtils.getNavigationBarHeight((Context)ctx));
        }
        this.createItems();
        return this.mContainer;
    }

    public void onProfileClick() {
        IProfile profile;
        if (this.mCrossFader != null && this.mCrossFader.isCrossfaded()) {
            this.mCrossFader.crossfade();
        }
        if (this.mAccountHeader != null && (profile = this.mAccountHeader.getActiveProfile()) instanceof IDrawerItem) {
            this.mDrawerAdapter.setDrawerItem(0, this.generateMiniDrawerItem((IDrawerItem)((Object)profile)));
        }
    }

    public boolean onItemClick(IDrawerItem selectedDrawerItem) {
        if (selectedDrawerItem.isSelectable()) {
            if (this.mCrossFader != null && this.mCrossFader.isCrossfaded()) {
                this.mCrossFader.crossfade();
            }
            int identifier = selectedDrawerItem.getIdentifier();
            this.setSelection(identifier);
            return false;
        }
        return true;
    }

    public void setSelection(int identifier) {
        for (IDrawerItem drawerItem : this.mDrawerAdapter.getDrawerItems()) {
            drawerItem.withSetSelected(drawerItem.getIdentifier() == identifier);
        }
        this.mDrawerAdapter.notifyDataSetChanged();
    }

    public void updateItem(int identifier) {
        if (this.mDrawer != null && this.mDrawerAdapter != null && this.mDrawerAdapter.getDrawerItems() != null && identifier != -1) {
            IDrawerItem drawerItem = DrawerUtils.getDrawerItem(this.getDrawerItems(), identifier);
            for (int i = 0; i < this.mDrawerAdapter.getDrawerItems().size(); ++i) {
                IDrawerItem miniDrawerItem;
                if (this.mDrawerAdapter.getDrawerItems().get(i).getIdentifier() != drawerItem.getIdentifier() || (miniDrawerItem = this.generateMiniDrawerItem(drawerItem)) == null) continue;
                this.mDrawerAdapter.setDrawerItem(i, miniDrawerItem);
            }
        }
    }

    public void createItems() {
        IProfile profile;
        this.mDrawerAdapter.clearDrawerItems();
        if (this.mAccountHeader != null && (profile = this.mAccountHeader.getActiveProfile()) instanceof IDrawerItem) {
            this.mDrawerAdapter.addDrawerItem(this.generateMiniDrawerItem((IDrawerItem)((Object)profile)));
        }
        if (this.mDrawer != null && this.getDrawerItems() != null) {
            for (IDrawerItem drawerItem : this.getDrawerItems()) {
                IDrawerItem miniDrawerItem = this.generateMiniDrawerItem(drawerItem);
                if (miniDrawerItem == null) continue;
                this.mDrawerAdapter.addDrawerItem(miniDrawerItem);
            }
        }
        if (this.mOnMiniDrawerItemClickListener != null) {
            this.mDrawerAdapter.setOnClickListener(this.mOnMiniDrawerItemClickListener);
        } else {
            this.mDrawerAdapter.setOnClickListener(new BaseDrawerAdapter.OnClickListener(){

                @Override
                public void onClick(View v, int position, IDrawerItem item) {
                    int type = MiniDrawer.this.getMiniDrawerType(item);
                    if (type == 2) {
                        if (item.isSelectable()) {
                            if (MiniDrawer.this.mAccountHeader != null && MiniDrawer.this.mAccountHeader.isSelectionListShown()) {
                                MiniDrawer.this.mAccountHeader.toggleSelectionList(v.getContext());
                            }
                            MiniDrawer.this.mDrawer.setSelection(item, true);
                        } else if (MiniDrawer.this.mDrawer.getOnDrawerItemClickListener() != null) {
                            MiniDrawer.this.mDrawer.getOnDrawerItemClickListener().onItemClick(v, position, DrawerUtils.getDrawerItem((List<IDrawerItem>)MiniDrawer.this.getDrawerItems(), item.getIdentifier()));
                        }
                    } else if (type == 1) {
                        if (MiniDrawer.this.mAccountHeader != null && !MiniDrawer.this.mAccountHeader.isSelectionListShown()) {
                            MiniDrawer.this.mAccountHeader.toggleSelectionList(v.getContext());
                        }
                        if (MiniDrawer.this.mCrossFader != null) {
                            MiniDrawer.this.mCrossFader.crossfade();
                        }
                    }
                }
            });
        }
        this.mDrawerAdapter.setOnLongClickListener(this.mOnMiniDrawerItemLongClickListener);
        this.mRecyclerView.scrollToPosition(0);
    }

    private ArrayList<IDrawerItem> getDrawerItems() {
        return this.mDrawer.getOriginalDrawerItems() != null ? this.mDrawer.getOriginalDrawerItems() : this.mDrawer.getDrawerItems();
    }
}

