/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.mikepenz.materialdrawer.DrawerBuilder;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.adapter.BaseDrawerAdapter;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.model.ContainerDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Selectable;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;
import java.util.List;

class DrawerUtils {
    DrawerUtils() {
    }

    public static void onFooterDrawerItemClick(DrawerBuilder drawer, IDrawerItem drawerItem, View v, Boolean fireOnClick) {
        boolean checkable;
        boolean bl = checkable = drawerItem == null || !(drawerItem instanceof Selectable) || ((Selectable)((Object)drawerItem)).isSelectable();
        if (checkable) {
            drawer.resetStickyFooterSelection();
            if (Build.VERSION.SDK_INT >= 11) {
                v.setActivated(true);
            }
            v.setSelected(true);
            drawer.getAdapter().handleSelection(null, -1);
            drawer.mCurrentSelection = -1;
            if (drawer.mStickyFooterView != null && drawer.mStickyFooterView instanceof LinearLayout) {
                LinearLayout footer = (LinearLayout)drawer.mStickyFooterView;
                for (int i = 0; i < footer.getChildCount(); ++i) {
                    if (footer.getChildAt(i) != v) continue;
                    drawer.mCurrentStickyFooterSelection = i;
                    break;
                }
            }
        }
        if (fireOnClick != null) {
            boolean consumed = false;
            if (fireOnClick.booleanValue() && drawer.mOnDrawerItemClickListener != null) {
                consumed = drawer.mOnDrawerItemClickListener.onItemClick(v, -1, drawerItem);
            }
            if (!consumed) {
                drawer.closeDrawerDelayed();
            }
        }
    }

    public static boolean setRecyclerViewSelection(DrawerBuilder drawer, int position, boolean fireOnClick) {
        return DrawerUtils.setRecyclerViewSelection(drawer, position, fireOnClick, null);
    }

    public static boolean setRecyclerViewSelection(DrawerBuilder drawer, int position, boolean fireOnClick, IDrawerItem drawerItem) {
        if (position >= -1) {
            if (drawer.mAdapter != null) {
                drawer.resetStickyFooterSelection();
                drawer.mAdapter.handleSelection(null, position);
                drawer.mCurrentSelection = position;
                drawer.mCurrentStickyFooterSelection = -1;
            }
            if (fireOnClick && drawer.mOnDrawerItemClickListener != null) {
                return drawer.mOnDrawerItemClickListener.onItemClick(null, position, drawerItem);
            }
        }
        return false;
    }

    public static void setStickyFooterSelection(DrawerBuilder drawer, int position, Boolean fireOnClick) {
        LinearLayout footer;
        if (position > -1 && drawer.mStickyFooterView != null && drawer.mStickyFooterView instanceof LinearLayout && (footer = (LinearLayout)drawer.mStickyFooterView).getChildCount() > position && position >= 0) {
            IDrawerItem drawerItem = (IDrawerItem)footer.getChildAt(position).getTag();
            DrawerUtils.onFooterDrawerItemClick(drawer, drawerItem, footer.getChildAt(position), fireOnClick);
        }
    }

    public static int getPositionByIdentifier(DrawerBuilder drawer, int identifier) {
        if (identifier >= 0) {
            BaseDrawerAdapter adapter = drawer.getAdapter();
            for (int i = 0; i < adapter.getItemCount(); ++i) {
                if (adapter.getItem(i).getIdentifier() != identifier) continue;
                return i;
            }
        }
        return -1;
    }

    public static IDrawerItem getDrawerItem(List<IDrawerItem> drawerItems, int identifier) {
        if (identifier >= 0) {
            for (IDrawerItem drawerItem : drawerItems) {
                if (drawerItem.getIdentifier() != identifier) continue;
                return drawerItem;
            }
        }
        return null;
    }

    public static IDrawerItem getDrawerItem(List<IDrawerItem> drawerItems, Object tag) {
        if (tag != null) {
            for (IDrawerItem drawerItem : drawerItems) {
                if (!tag.equals(drawerItem.getTag())) continue;
                return drawerItem;
            }
        }
        return null;
    }

    public static int getStickyFooterPositionByIdentifier(DrawerBuilder drawer, int identifier) {
        if (identifier >= 0 && drawer.mStickyFooterView != null && drawer.mStickyFooterView instanceof LinearLayout) {
            LinearLayout footer = (LinearLayout)drawer.mStickyFooterView;
            int shadowOffset = 0;
            for (int i = 0; i < footer.getChildCount(); ++i) {
                Object o = footer.getChildAt(i).getTag();
                if (o == null && drawer.mStickyFooterDivider) {
                    ++shadowOffset;
                }
                if (o == null || !(o instanceof IDrawerItem) || ((IDrawerItem)o).getIdentifier() != identifier) continue;
                return i - shadowOffset;
            }
        }
        return -1;
    }

    public static void handleHeaderView(DrawerBuilder drawer) {
        if (drawer.mAccountHeader != null) {
            if (drawer.mAccountHeaderSticky) {
                drawer.mStickyHeaderView = drawer.mAccountHeader.getView();
            } else {
                drawer.mHeaderView = drawer.mAccountHeader.getView();
                drawer.mHeaderDivider = drawer.mAccountHeader.mAccountHeaderBuilder.mDividerBelowHeader;
                drawer.mHeaderPadding = drawer.mAccountHeader.mAccountHeaderBuilder.mPaddingBelowHeader;
            }
        }
        if (drawer.mStickyHeaderView != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(10, 1);
            drawer.mStickyHeaderView.setId(R.id.material_drawer_sticky_header);
            drawer.mSliderLayout.addView(drawer.mStickyHeaderView, 0, (ViewGroup.LayoutParams)layoutParams);
            RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)drawer.mRecyclerView.getLayoutParams();
            layoutParamsListView.addRule(3, R.id.material_drawer_sticky_header);
            drawer.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
            drawer.mStickyHeaderView.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)drawer.mActivity, (int)R.attr.material_drawer_background, (int)R.color.material_drawer_background));
            if (Build.VERSION.SDK_INT >= 21) {
                drawer.mStickyHeaderView.setElevation(UIUtils.convertDpToPixel((float)4.0f, (Context)drawer.mActivity));
            } else {
                View view = new View((Context)drawer.mActivity);
                view.setBackgroundResource(R.drawable.material_drawer_shadow_bottom);
                drawer.mSliderLayout.addView(view, -1, (int)UIUtils.convertDpToPixel((float)4.0f, (Context)drawer.mActivity));
                RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)view.getLayoutParams();
                lps.addRule(3, R.id.material_drawer_sticky_header);
                view.setLayoutParams((ViewGroup.LayoutParams)lps);
            }
            drawer.mRecyclerView.setPadding(0, 0, 0, 0);
        }
        if (drawer.mHeaderView != null) {
            if (drawer.mRecyclerView == null) {
                throw new RuntimeException("can't use a headerView without a recyclerView");
            }
            if (drawer.mHeaderPadding) {
                drawer.getAdapter().addHeaderDrawerItems(new ContainerDrawerItem().withView(drawer.mHeaderView).withDivider(drawer.mHeaderDivider).withViewPosition(ContainerDrawerItem.Position.TOP));
            } else {
                drawer.getAdapter().addHeaderDrawerItems(new ContainerDrawerItem().withView(drawer.mHeaderView).withDivider(drawer.mHeaderDivider).withViewPosition(ContainerDrawerItem.Position.NONE));
            }
            drawer.mRecyclerView.setPadding(drawer.mRecyclerView.getPaddingLeft(), 0, drawer.mRecyclerView.getPaddingRight(), drawer.mRecyclerView.getPaddingBottom());
        }
    }

    public static void rebuildStickyFooterView(final DrawerBuilder drawer) {
        if (drawer.mSliderLayout != null) {
            if (drawer.mStickyFooterView != null) {
                drawer.mStickyFooterView.removeAllViews();
                if (drawer.mStickyFooterDivider) {
                    DrawerUtils.addStickyFooterDivider(drawer.mStickyFooterView.getContext(), drawer.mStickyFooterView);
                }
                DrawerUtils.fillStickyDrawerItemFooter(drawer, drawer.mStickyFooterView, new View.OnClickListener(){

                    public void onClick(View v) {
                        IDrawerItem drawerItem = (IDrawerItem)v.getTag();
                        DrawerUtils.onFooterDrawerItemClick(drawer, drawerItem, v, true);
                    }
                });
                drawer.mStickyFooterView.setVisibility(0);
            } else {
                DrawerUtils.handleFooterView(drawer, new View.OnClickListener(){

                    public void onClick(View v) {
                        IDrawerItem drawerItem = (IDrawerItem)v.getTag();
                        DrawerUtils.onFooterDrawerItemClick(drawer, drawerItem, v, true);
                    }
                });
            }
            DrawerUtils.setStickyFooterSelection(drawer, drawer.mCurrentStickyFooterSelection, false);
        }
    }

    public static void handleFooterView(DrawerBuilder drawer, View.OnClickListener onClickListener) {
        Context ctx = drawer.mSliderLayout.getContext();
        if (drawer.mStickyDrawerItems != null && drawer.mStickyDrawerItems.size() > 0) {
            drawer.mStickyFooterView = DrawerUtils.buildStickyDrawerItemFooter(ctx, drawer, onClickListener);
        }
        if (drawer.mStickyFooterView != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(12, 1);
            drawer.mStickyFooterView.setId(R.id.material_drawer_sticky_footer);
            drawer.mSliderLayout.addView((View)drawer.mStickyFooterView, (ViewGroup.LayoutParams)layoutParams);
            if ((drawer.mTranslucentNavigationBar || drawer.mFullscreen) && Build.VERSION.SDK_INT >= 19) {
                drawer.mStickyFooterView.setPadding(0, 0, 0, UIUtils.getNavigationBarHeight((Context)ctx));
            }
            RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)drawer.mRecyclerView.getLayoutParams();
            layoutParamsListView.addRule(2, R.id.material_drawer_sticky_footer);
            drawer.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
            if (drawer.mStickyFooterShadow) {
                drawer.mStickyFooterShadowView = new View(ctx);
                drawer.mStickyFooterShadowView.setBackgroundResource(R.drawable.material_drawer_shadow_top);
                drawer.mSliderLayout.addView(drawer.mStickyFooterShadowView, -1, (int)UIUtils.convertDpToPixel((float)4.0f, (Context)ctx));
                RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)drawer.mStickyFooterShadowView.getLayoutParams();
                lps.addRule(2, R.id.material_drawer_sticky_footer);
                drawer.mStickyFooterShadowView.setLayoutParams((ViewGroup.LayoutParams)lps);
            }
            drawer.mRecyclerView.setPadding(drawer.mRecyclerView.getPaddingLeft(), drawer.mRecyclerView.getPaddingTop(), drawer.mRecyclerView.getPaddingRight(), ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding));
        }
        if (drawer.mFooterView != null) {
            if (drawer.mRecyclerView == null) {
                throw new RuntimeException("can't use a footerView without a recyclerView");
            }
            if (drawer.mFooterDivider) {
                drawer.getAdapter().addFooterDrawerItems(new ContainerDrawerItem().withView(drawer.mFooterView).withViewPosition(ContainerDrawerItem.Position.BOTTOM));
            } else {
                drawer.getAdapter().addFooterDrawerItems(new ContainerDrawerItem().withView(drawer.mFooterView).withViewPosition(ContainerDrawerItem.Position.NONE));
            }
        }
    }

    public static ViewGroup buildStickyDrawerItemFooter(Context ctx, DrawerBuilder drawer, View.OnClickListener onClickListener) {
        LinearLayout linearLayout = new LinearLayout(ctx);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        linearLayout.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_background, (int)R.color.material_drawer_background));
        if (drawer.mStickyFooterDivider) {
            DrawerUtils.addStickyFooterDivider(ctx, (ViewGroup)linearLayout);
        }
        DrawerUtils.fillStickyDrawerItemFooter(drawer, (ViewGroup)linearLayout, onClickListener);
        return linearLayout;
    }

    private static void addStickyFooterDivider(Context ctx, ViewGroup footerView) {
        LinearLayout divider = new LinearLayout(ctx);
        LinearLayout.LayoutParams dividerParams = new LinearLayout.LayoutParams(-1, -2);
        divider.setMinimumHeight((int)UIUtils.convertDpToPixel((float)1.0f, (Context)ctx));
        divider.setOrientation(1);
        divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
        footerView.addView((View)divider, (ViewGroup.LayoutParams)dividerParams);
    }

    public static void fillStickyDrawerItemFooter(DrawerBuilder drawer, ViewGroup container, View.OnClickListener onClickListener) {
        for (IDrawerItem drawerItem : drawer.mStickyDrawerItems) {
            int selected_color = UIUtils.getThemeColorFromAttrOrRes((Context)container.getContext(), (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
            if (drawerItem instanceof PrimaryDrawerItem) {
                selected_color = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)((PrimaryDrawerItem)drawerItem).getSelectedColor(), (Context)container.getContext(), (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
            } else if (drawerItem instanceof SecondaryDrawerItem) {
                selected_color = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)((SecondaryDrawerItem)drawerItem).getSelectedColor(), (Context)container.getContext(), (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
            }
            View view = drawerItem.generateView(container.getContext(), container);
            view.setTag((Object)drawerItem);
            if (drawerItem.isEnabled()) {
                UIUtils.setBackground((View)view, (Drawable)DrawerUIUtils.getSelectableBackground(container.getContext(), selected_color));
                view.setOnClickListener(onClickListener);
            }
            container.addView(view);
            DrawerUIUtils.setDrawerVerticalPadding(view);
        }
        container.setPadding(0, 0, 0, 0);
    }

    public static DrawerLayout.LayoutParams processDrawerLayoutParams(DrawerBuilder drawer, DrawerLayout.LayoutParams params) {
        if (params != null) {
            if (drawer.mDrawerGravity != null && (drawer.mDrawerGravity == 5 || drawer.mDrawerGravity == 0x800005)) {
                params.rightMargin = 0;
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(0);
                }
                params.leftMargin = drawer.mActivity.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(drawer.mActivity.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin));
                }
            }
            if (drawer.mDisplayBelowStatusBar != null && drawer.mDisplayBelowStatusBar.booleanValue() && Build.VERSION.SDK_INT >= 19) {
                params.topMargin = UIUtils.getStatusBarHeight((Context)drawer.mActivity, (boolean)true);
            }
            params.width = drawer.mDrawerWidth > -1 ? drawer.mDrawerWidth : DrawerUIUtils.getOptimalDrawerWidth((Context)drawer.mActivity);
        }
        return params;
    }
}

