/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.mikepenz.materialdrawer.DrawerBuilder;
import com.mikepenz.materialdrawer.DrawerUtils;
import com.mikepenz.materialdrawer.MiniDrawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.adapter.BaseDrawerAdapter;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.ContainerDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Badgeable;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Iconable;
import com.mikepenz.materialdrawer.model.interfaces.Identifyable;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialdrawer.util.IdDistributor;
import com.mikepenz.materialdrawer.util.KeyboardUtil;
import com.mikepenz.materialize.Materialize;
import com.mikepenz.materialize.view.IScrimInsetsLayout;
import java.util.ArrayList;

public class Drawer {
    protected static final String BUNDLE_SELECTION = "bundle_selection";
    protected static final String BUNDLE_SELECTION_APPENDED = "bundle_selection_appended";
    protected static final String BUNDLE_STICKY_FOOTER_SELECTION = "bundle_sticky_footer_selection";
    protected static final String BUNDLE_STICKY_FOOTER_SELECTION_APPENDED = "bundle_sticky_footer_selection_appended";
    protected static final String BUNDLE_DRAWER_CONTENT_SWITCHED = "bundle_drawer_content_switched";
    protected static final String BUNDLE_DRAWER_CONTENT_SWITCHED_APPENDED = "bundle_drawer_content_switched_appended";
    protected static final String PREF_USER_LEARNED_DRAWER = "navigation_drawer_learned";
    protected final DrawerBuilder mDrawerBuilder;
    private FrameLayout mContentView;
    private KeyboardUtil mKeyboardUtil = null;
    private OnDrawerItemClickListener originalOnDrawerItemClickListener;
    private OnDrawerItemLongClickListener originalOnDrawerItemLongClickListener;
    private ArrayList<IDrawerItem> originalDrawerItems;
    private int originalDrawerSelection = -1;

    protected Drawer(DrawerBuilder drawerBuilder) {
        this.mDrawerBuilder = drawerBuilder;
    }

    protected DrawerBuilder getDrawerBuilder() {
        return this.mDrawerBuilder;
    }

    public DrawerLayout getDrawerLayout() {
        return this.mDrawerBuilder.mDrawerLayout;
    }

    public void setToolbar(@NonNull Activity activity, @NonNull Toolbar toolbar) {
        this.setToolbar(activity, toolbar, false);
    }

    public void setToolbar(@NonNull Activity activity, @NonNull Toolbar toolbar, boolean recreateActionBarDrawerToggle) {
        this.mDrawerBuilder.mToolbar = toolbar;
        this.mDrawerBuilder.handleDrawerNavigation(activity, recreateActionBarDrawerToggle);
    }

    public void setActionBarDrawerToggle(@NonNull ActionBarDrawerToggle actionBarDrawerToggle) {
        this.mDrawerBuilder.mActionBarDrawerToggleEnabled = true;
        this.mDrawerBuilder.mActionBarDrawerToggle = actionBarDrawerToggle;
        this.mDrawerBuilder.handleDrawerNavigation(null, false);
    }

    public void openDrawer() {
        if (this.mDrawerBuilder.mDrawerLayout != null && this.mDrawerBuilder.mSliderLayout != null) {
            this.mDrawerBuilder.mDrawerLayout.openDrawer(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
    }

    public void closeDrawer() {
        if (this.mDrawerBuilder.mDrawerLayout != null) {
            this.mDrawerBuilder.mDrawerLayout.closeDrawer(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
    }

    public boolean isDrawerOpen() {
        if (this.mDrawerBuilder.mDrawerLayout != null && this.mDrawerBuilder.mSliderLayout != null) {
            return this.mDrawerBuilder.mDrawerLayout.isDrawerOpen(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
        return false;
    }

    public void setFullscreen(boolean fullscreen) {
        if (this.mDrawerBuilder.mMaterialize != null) {
            this.mDrawerBuilder.mMaterialize.setFullscreen(fullscreen);
        }
    }

    public void setStatusBarColor(@ColorInt int statusBarColor) {
        if (this.mDrawerBuilder.mMaterialize != null) {
            this.mDrawerBuilder.mMaterialize.setStatusBarColor(statusBarColor);
            this.mDrawerBuilder.mMaterialize.getScrimInsetsFrameLayout().getView().invalidate();
        }
    }

    public IScrimInsetsLayout getScrimInsetsFrameLayout() {
        if (this.mDrawerBuilder.mMaterialize != null) {
            return this.mDrawerBuilder.mMaterialize.getScrimInsetsFrameLayout();
        }
        return null;
    }

    public Materialize getMaterialize() {
        return this.mDrawerBuilder.mMaterialize;
    }

    public MiniDrawer getMiniDrawer() {
        if (this.mDrawerBuilder.mMiniDrawer == null) {
            this.mDrawerBuilder.mMiniDrawer = new MiniDrawer().withDrawer(this).withAccountHeader(this.mDrawerBuilder.mAccountHeader);
        }
        return this.mDrawerBuilder.mMiniDrawer;
    }

    public void keyboardSupportEnabled(@NonNull Activity activity, boolean enable) {
        if (this.getContent() != null && this.getContent().getChildCount() > 0) {
            if (this.mKeyboardUtil == null) {
                this.mKeyboardUtil = new KeyboardUtil(activity, this.getContent().getChildAt(0));
                this.mKeyboardUtil.disable();
            }
            if (enable) {
                this.mKeyboardUtil.enable();
            } else {
                this.mKeyboardUtil.disable();
            }
        }
    }

    public RelativeLayout getSlider() {
        return this.mDrawerBuilder.mSliderLayout;
    }

    public FrameLayout getContent() {
        if (this.mContentView == null && this.mDrawerBuilder.mDrawerLayout != null) {
            this.mContentView = (FrameLayout)this.mDrawerBuilder.mDrawerLayout.findViewById(R.id.content_layout);
        }
        return this.mContentView;
    }

    public RecyclerView getRecyclerView() {
        return this.mDrawerBuilder.mRecyclerView;
    }

    public BaseDrawerAdapter getAdapter() {
        return this.mDrawerBuilder.mAdapter;
    }

    public ArrayList<IDrawerItem> getDrawerItems() {
        return this.mDrawerBuilder.getAdapter().getDrawerItems();
    }

    public View getHeader() {
        return this.mDrawerBuilder.mHeaderView;
    }

    public View getStickyHeader() {
        return this.mDrawerBuilder.mStickyHeaderView;
    }

    public void setHeader(@NonNull View view) {
        this.setHeader(view, true, true);
    }

    public void setHeader(@NonNull View view, boolean divider) {
        this.setHeader(view, true, divider);
    }

    public void setHeader(@NonNull View view, boolean padding, boolean divider) {
        this.getAdapter().clearHeaderItems();
        if (padding) {
            this.getAdapter().addHeaderDrawerItems(new ContainerDrawerItem().withView(view).withDivider(divider).withViewPosition(ContainerDrawerItem.Position.TOP));
        } else {
            this.getAdapter().addHeaderDrawerItems(new ContainerDrawerItem().withView(view).withDivider(divider).withViewPosition(ContainerDrawerItem.Position.NONE));
        }
    }

    public void removeHeader() {
        this.getAdapter().clearHeaderItems();
    }

    public View getFooter() {
        return this.mDrawerBuilder.mFooterView;
    }

    public View getStickyFooter() {
        return this.mDrawerBuilder.mStickyFooterView;
    }

    private View getStickyFooterShadow() {
        return this.mDrawerBuilder.mStickyFooterShadowView;
    }

    public ActionBarDrawerToggle getActionBarDrawerToggle() {
        return this.mDrawerBuilder.mActionBarDrawerToggle;
    }

    public int getPosition(@NonNull IDrawerItem drawerItem) {
        return this.getPosition(drawerItem.getIdentifier());
    }

    public int getPosition(int identifier) {
        return DrawerUtils.getPositionByIdentifier(this.mDrawerBuilder, identifier);
    }

    public IDrawerItem getDrawerItem(int identifier) {
        return this.getAdapter().getItem(this.getPosition(identifier));
    }

    public IDrawerItem getDrawerItem(Object tag) {
        return DrawerUtils.getDrawerItem(this.getDrawerItems(), tag);
    }

    public int getStickyFooterPosition(@NonNull IDrawerItem drawerItem) {
        return this.getStickyFooterPosition(drawerItem.getIdentifier());
    }

    public int getStickyFooterPosition(int identifier) {
        return DrawerUtils.getStickyFooterPositionByIdentifier(this.mDrawerBuilder, identifier);
    }

    public int getCurrentSelectedPosition() {
        return this.mDrawerBuilder.mCurrentSelection;
    }

    public int getCurrentSelection() {
        IDrawerItem drawerItem = this.mDrawerBuilder.getDrawerItem(this.mDrawerBuilder.mCurrentSelection);
        if (drawerItem != null) {
            return drawerItem.getIdentifier();
        }
        return -1;
    }

    public int getCurrentStickyFooterSelectedPosition() {
        return this.mDrawerBuilder.mCurrentStickyFooterSelection;
    }

    public boolean setSelection(int identifier) {
        return this.setSelectionAtPosition(this.getPosition(identifier), true);
    }

    public boolean setSelection(int identifier, boolean fireOnClick) {
        return this.setSelectionAtPosition(this.getPosition(identifier), fireOnClick);
    }

    public void setStickyFooterSelection(int identifier, boolean fireOnClick) {
        this.setStickyFooterSelectionAtPosition(this.getStickyFooterPosition(identifier), fireOnClick);
    }

    public boolean setSelection(@NonNull IDrawerItem drawerItem) {
        return this.setSelectionAtPosition(this.getPosition(drawerItem), true);
    }

    public boolean setSelection(@NonNull IDrawerItem drawerItem, boolean fireOnClick) {
        return this.setSelectionAtPosition(this.getPosition(drawerItem), fireOnClick);
    }

    public boolean setSelectionAtPosition(int position) {
        return this.setSelectionAtPosition(position, true);
    }

    public boolean setSelectionAtPosition(int position, boolean fireOnClick) {
        if (this.mDrawerBuilder.mRecyclerView != null) {
            return DrawerUtils.setRecyclerViewSelection(this.mDrawerBuilder, position, fireOnClick, this.mDrawerBuilder.getDrawerItem(position));
        }
        return false;
    }

    public void setStickyFooterSelectionAtPosition(int position) {
        this.setStickyFooterSelectionAtPosition(position, true);
    }

    public void setStickyFooterSelectionAtPosition(int position, boolean fireOnClick) {
        DrawerUtils.setStickyFooterSelection(this.mDrawerBuilder, position, fireOnClick);
    }

    public void updateItem(@NonNull IDrawerItem drawerItem) {
        this.updateItemAtPosition(drawerItem, this.getPosition(drawerItem));
    }

    public void updateBadge(int identifier, StringHolder badge) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Badgeable) {
            Badgeable badgeable = (Badgeable)((Object)drawerItem);
            badgeable.withBadge(badge);
            this.updateItem((IDrawerItem)((Object)badgeable));
        }
    }

    public void updateName(int identifier, StringHolder name) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Nameable) {
            Nameable pdi = (Nameable)((Object)drawerItem);
            pdi.withName(name);
            this.updateItem((IDrawerItem)((Object)pdi));
        }
    }

    public void updateIcon(int identifier, ImageHolder image) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Iconable) {
            Iconable pdi = (Iconable)((Object)drawerItem);
            pdi.withIcon(image);
            this.updateItem((IDrawerItem)((Object)pdi));
        }
    }

    public void updateItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.checkDrawerItem(position, false)) {
            this.mDrawerBuilder.getAdapter().setDrawerItem(position, drawerItem);
        }
    }

    public void addItem(@NonNull IDrawerItem drawerItem) {
        this.mDrawerBuilder.getAdapter().addDrawerItem(IdDistributor.checkId(drawerItem));
    }

    public void addItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        this.mDrawerBuilder.getAdapter().addDrawerItem(position, IdDistributor.checkId(drawerItem));
        if (position < this.mDrawerBuilder.mCurrentSelection) {
            ++this.mDrawerBuilder.mCurrentSelection;
        }
    }

    public void setItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        this.mDrawerBuilder.getAdapter().addDrawerItem(position, IdDistributor.checkId(drawerItem));
    }

    public void removeItemByPosition(int position) {
        if (this.mDrawerBuilder.checkDrawerItem(position, false)) {
            this.mDrawerBuilder.getAdapter().removeDrawerItem(position);
            if (position < this.mDrawerBuilder.mCurrentSelection) {
                --this.mDrawerBuilder.mCurrentSelection;
            }
        }
    }

    public void removeItem(int identifier) {
        int position = this.getPosition(identifier);
        if (this.mDrawerBuilder.checkDrawerItem(position, false)) {
            this.mDrawerBuilder.getAdapter().removeDrawerItem(position);
            if (position < this.mDrawerBuilder.mCurrentSelection) {
                --this.mDrawerBuilder.mCurrentSelection;
            }
        }
    }

    public void removeItems(int ... identifiers) {
        if (identifiers != null) {
            for (int identifier : identifiers) {
                this.removeItem(identifier);
            }
        }
    }

    public void removeAllItems() {
        this.mDrawerBuilder.getAdapter().clearDrawerItems();
        this.mDrawerBuilder.mCurrentSelection = -1;
    }

    public void addItems(IDrawerItem ... drawerItems) {
        this.mDrawerBuilder.getAdapter().addDrawerItems((IDrawerItem[])IdDistributor.checkIds((Identifyable[])drawerItems));
    }

    public void addItemsAtPosition(int position, IDrawerItem ... drawerItems) {
        this.mDrawerBuilder.getAdapter().addDrawerItems(position, (IDrawerItem[])IdDistributor.checkIds((Identifyable[])drawerItems));
    }

    public void setItems(@NonNull ArrayList<IDrawerItem> drawerItems) {
        this.setItems(IdDistributor.checkIds(drawerItems), false);
    }

    private void setItems(@NonNull ArrayList<IDrawerItem> drawerItems, boolean switchedItems) {
        if (this.originalDrawerItems != null && !switchedItems) {
            this.originalDrawerItems = drawerItems;
            this.mDrawerBuilder.mCurrentSelection = -1;
        } else {
            this.mDrawerBuilder.getAdapter().setDrawerItems(drawerItems);
        }
        this.mDrawerBuilder.mAdapter.notifyDataSetChanged();
    }

    public void updateStickyFooterItem(@NonNull IDrawerItem drawerItem) {
        this.updateStickyFooterItemAtPosition(drawerItem, this.getStickyFooterPosition(drawerItem));
    }

    public void updateStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.set(position, drawerItem);
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void addStickyFooterItem(@NonNull IDrawerItem drawerItem) {
        if (this.mDrawerBuilder.mStickyDrawerItems == null) {
            this.mDrawerBuilder.mStickyDrawerItems = new ArrayList();
        }
        this.mDrawerBuilder.mStickyDrawerItems.add(IdDistributor.checkId(drawerItem));
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void addStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems == null) {
            this.mDrawerBuilder.mStickyDrawerItems = new ArrayList();
        }
        this.mDrawerBuilder.mStickyDrawerItems.add(position, IdDistributor.checkId(drawerItem));
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void setStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.set(position, IdDistributor.checkId(drawerItem));
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void removeStickyFooterItemAtPosition(int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.remove(position);
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void removeAllStickyFooterItems() {
        if (this.mDrawerBuilder.mStickyDrawerItems != null) {
            this.mDrawerBuilder.mStickyDrawerItems.clear();
        }
        if (this.mDrawerBuilder.mStickyFooterView != null) {
            this.mDrawerBuilder.mStickyFooterView.setVisibility(8);
        }
    }

    public void setOnDrawerItemClickListener(OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mDrawerBuilder.mOnDrawerItemClickListener = onDrawerItemClickListener;
    }

    public OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mDrawerBuilder.mOnDrawerItemClickListener;
    }

    public void setOnDrawerItemLongClickListener(OnDrawerItemLongClickListener onDrawerItemLongClickListener) {
        this.mDrawerBuilder.mOnDrawerItemLongClickListener = onDrawerItemLongClickListener;
    }

    public OnDrawerItemLongClickListener getOnDrawerItemLongClickListener() {
        return this.mDrawerBuilder.mOnDrawerItemLongClickListener;
    }

    public boolean switchedDrawerContent() {
        return this.originalOnDrawerItemClickListener != null || this.originalDrawerItems != null || this.originalDrawerSelection != -1;
    }

    public ArrayList<IDrawerItem> getOriginalDrawerItems() {
        return this.originalDrawerItems;
    }

    public void switchDrawerContent(@NonNull OnDrawerItemClickListener onDrawerItemClickListener, OnDrawerItemLongClickListener onDrawerItemLongClickListener, @NonNull ArrayList<IDrawerItem> drawerItems, int drawerSelection) {
        if (!this.switchedDrawerContent()) {
            this.originalOnDrawerItemClickListener = this.getOnDrawerItemClickListener();
            this.originalOnDrawerItemLongClickListener = this.getOnDrawerItemLongClickListener();
            this.originalDrawerItems = this.getDrawerItems();
            this.originalDrawerSelection = this.getCurrentSelectedPosition();
        }
        this.setOnDrawerItemClickListener(onDrawerItemClickListener);
        this.setOnDrawerItemLongClickListener(onDrawerItemLongClickListener);
        this.setItems(drawerItems, true);
        this.setSelectionAtPosition(drawerSelection, false);
        if (this.getStickyFooter() != null) {
            this.getStickyFooter().setVisibility(8);
        }
        if (this.getStickyFooterShadow() != null) {
            this.getStickyFooterShadow().setVisibility(8);
        }
    }

    public void resetDrawerContent() {
        if (this.switchedDrawerContent()) {
            this.setOnDrawerItemClickListener(this.originalOnDrawerItemClickListener);
            this.setOnDrawerItemLongClickListener(this.originalOnDrawerItemLongClickListener);
            this.setItems(this.originalDrawerItems, true);
            this.setSelectionAtPosition(this.originalDrawerSelection, false);
            this.originalOnDrawerItemClickListener = null;
            this.originalOnDrawerItemLongClickListener = null;
            this.originalDrawerItems = null;
            this.originalDrawerSelection = -1;
            this.mDrawerBuilder.mRecyclerView.smoothScrollToPosition(0);
            if (this.getStickyFooter() != null) {
                this.getStickyFooter().setVisibility(0);
            }
            if (this.getStickyFooterShadow() != null) {
                this.getStickyFooterShadow().setVisibility(0);
            }
            if (this.mDrawerBuilder.mAccountHeader != null && this.mDrawerBuilder.mAccountHeader.mAccountHeaderBuilder != null) {
                this.mDrawerBuilder.mAccountHeader.mAccountHeaderBuilder.mSelectionListShown = false;
            }
        }
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            if (!this.mDrawerBuilder.mAppended) {
                savedInstanceState.putInt(BUNDLE_SELECTION, this.switchedDrawerContent() ? this.originalDrawerSelection : this.mDrawerBuilder.mCurrentSelection);
                savedInstanceState.putInt(BUNDLE_STICKY_FOOTER_SELECTION, this.mDrawerBuilder.mCurrentStickyFooterSelection);
                savedInstanceState.putBoolean(BUNDLE_DRAWER_CONTENT_SWITCHED, this.switchedDrawerContent());
            } else {
                savedInstanceState.putInt(BUNDLE_SELECTION_APPENDED, this.switchedDrawerContent() ? this.originalDrawerSelection : this.mDrawerBuilder.mCurrentSelection);
                savedInstanceState.putInt(BUNDLE_STICKY_FOOTER_SELECTION_APPENDED, this.mDrawerBuilder.mCurrentStickyFooterSelection);
                savedInstanceState.putBoolean(BUNDLE_DRAWER_CONTENT_SWITCHED_APPENDED, this.switchedDrawerContent());
            }
        }
        return savedInstanceState;
    }

    public static interface OnDrawerItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4, IDrawerItem var6);

        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnDrawerListener {
        public void onDrawerOpened(View var1);

        public void onDrawerClosed(View var1);

        public void onDrawerSlide(View var1, float var2);
    }

    public static interface OnDrawerItemLongClickListener {
        public boolean onItemLongClick(View var1, int var2, IDrawerItem var3);
    }

    public static interface OnDrawerItemClickListener {
        public boolean onItemClick(View var1, int var2, IDrawerItem var3);
    }

    public static interface OnDrawerNavigationListener {
        public boolean onNavigationClickListener(View var1);
    }
}

