/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.mikepenz.materialdrawer.AccountHeaderBuilder;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.model.interfaces.Identifyable;
import com.mikepenz.materialdrawer.util.IdDistributor;
import java.util.ArrayList;
import java.util.Collections;

public class AccountHeader {
    protected static final double NAVIGATION_DRAWER_ACCOUNT_ASPECT_RATIO = 0.5625;
    protected static final String BUNDLE_SELECTION_HEADER = "bundle_selection_header";
    protected final AccountHeaderBuilder mAccountHeaderBuilder;

    protected AccountHeader(AccountHeaderBuilder accountHeaderBuilder) {
        this.mAccountHeaderBuilder = accountHeaderBuilder;
    }

    public View getView() {
        return this.mAccountHeaderBuilder.mAccountHeaderContainer;
    }

    public void setDrawer(Drawer drawer) {
        this.mAccountHeaderBuilder.mDrawer = drawer;
    }

    public ImageView getHeaderBackgroundView() {
        return this.mAccountHeaderBuilder.mAccountHeaderBackground;
    }

    public void setHeaderBackground(ImageHolder imageHolder) {
        ImageHolder.applyTo((com.mikepenz.materialize.holder.ImageHolder)imageHolder, (ImageView)this.mAccountHeaderBuilder.mAccountHeaderBackground);
    }

    public void setBackground(Drawable headerBackground) {
        this.mAccountHeaderBuilder.mAccountHeaderBackground.setImageDrawable(headerBackground);
    }

    public void setBackgroundRes(@DrawableRes int headerBackgroundRes) {
        this.mAccountHeaderBuilder.mAccountHeaderBackground.setImageResource(headerBackgroundRes);
    }

    public void toggleSelectionList(Context ctx) {
        this.mAccountHeaderBuilder.toggleSelectionList(ctx);
    }

    public boolean isSelectionListShown() {
        return this.mAccountHeaderBuilder.mSelectionListShown;
    }

    public void setSelectionFirstLineShown(boolean selectionFirstLineShown) {
        this.mAccountHeaderBuilder.mSelectionFirstLineShown = selectionFirstLineShown;
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void setSelectionSecondLineShown(boolean selectionSecondLineShown) {
        this.mAccountHeaderBuilder.mSelectionSecondLineShown = selectionSecondLineShown;
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void setSelectionFirstLine(String selectionFirstLine) {
        this.mAccountHeaderBuilder.mSelectionFirstLine = selectionFirstLine;
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void setSelectionSecondLine(String selectionSecondLine) {
        this.mAccountHeaderBuilder.mSelectionSecondLine = selectionSecondLine;
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public ArrayList<IProfile> getProfiles() {
        return this.mAccountHeaderBuilder.mProfiles;
    }

    public void setProfiles(ArrayList<IProfile> profiles) {
        this.mAccountHeaderBuilder.mProfiles = IdDistributor.checkIds(profiles);
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void setActiveProfile(IProfile profile) {
        this.setActiveProfile(profile, false);
    }

    public void setActiveProfile(IProfile profile, boolean fireOnProfileChanged) {
        boolean isCurrentSelectedProfile = this.mAccountHeaderBuilder.switchProfiles(profile);
        if (this.mAccountHeaderBuilder.mDrawer != null && this.isSelectionListShown()) {
            this.mAccountHeaderBuilder.mDrawer.setSelection(profile.getIdentifier(), false);
        }
        if (fireOnProfileChanged && this.mAccountHeaderBuilder.mOnAccountHeaderListener != null) {
            this.mAccountHeaderBuilder.mOnAccountHeaderListener.onProfileChanged(null, profile, isCurrentSelectedProfile);
        }
    }

    public void setActiveProfile(int identifier) {
        this.setActiveProfile(identifier, false);
    }

    public void setActiveProfile(int identifier, boolean fireOnProfileChanged) {
        if (this.mAccountHeaderBuilder.mProfiles != null) {
            for (IProfile profile : this.mAccountHeaderBuilder.mProfiles) {
                if (profile == null || profile.getIdentifier() != identifier) continue;
                this.setActiveProfile(profile, fireOnProfileChanged);
                return;
            }
        }
    }

    public IProfile getActiveProfile() {
        return this.mAccountHeaderBuilder.mCurrentProfile;
    }

    public void updateProfile(@NonNull IProfile newProfile) {
        this.updateProfileByIdentifier(newProfile);
    }

    @Deprecated
    public void updateProfileByIdentifier(@NonNull IProfile newProfile) {
        int found = this.getPositionByIdentifier(newProfile.getIdentifier());
        if (found > -1) {
            this.mAccountHeaderBuilder.mProfiles.set(found, newProfile);
            this.mAccountHeaderBuilder.updateHeaderAndList();
        }
    }

    public void addProfiles(IProfile ... profiles) {
        if (this.mAccountHeaderBuilder.mProfiles == null) {
            this.mAccountHeaderBuilder.mProfiles = new ArrayList();
        }
        Collections.addAll(this.mAccountHeaderBuilder.mProfiles, IdDistributor.checkIds((Identifyable[])profiles));
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void addProfile(@NonNull IProfile profile, int position) {
        if (this.mAccountHeaderBuilder.mProfiles == null) {
            this.mAccountHeaderBuilder.mProfiles = new ArrayList();
        }
        this.mAccountHeaderBuilder.mProfiles.add(position, IdDistributor.checkId(profile));
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void removeProfile(int position) {
        if (this.mAccountHeaderBuilder.mProfiles != null && this.mAccountHeaderBuilder.mProfiles.size() > position) {
            this.mAccountHeaderBuilder.mProfiles.remove(position);
        }
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void removeProfileByIdentifier(int identifier) {
        int found = this.getPositionByIdentifier(identifier);
        if (found > -1) {
            this.mAccountHeaderBuilder.mProfiles.remove(found);
        }
        this.mAccountHeaderBuilder.updateHeaderAndList();
    }

    public void removeProfile(@NonNull IProfile profile) {
        this.removeProfileByIdentifier(profile.getIdentifier());
    }

    public void clear() {
        this.mAccountHeaderBuilder.mProfiles = null;
        this.mAccountHeaderBuilder.calculateProfiles();
        this.mAccountHeaderBuilder.buildProfiles();
    }

    private int getPositionByIdentifier(int identifier) {
        int found = -1;
        if (this.mAccountHeaderBuilder.mProfiles != null && identifier >= 0) {
            for (int i = 0; i < this.mAccountHeaderBuilder.mProfiles.size(); ++i) {
                if (this.mAccountHeaderBuilder.mProfiles.get(i) == null || this.mAccountHeaderBuilder.mProfiles.get(i).getIdentifier() != identifier) continue;
                found = i;
                break;
            }
        }
        return found;
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.putInt(BUNDLE_SELECTION_HEADER, this.mAccountHeaderBuilder.getCurrentSelection());
        }
        return savedInstanceState;
    }

    public static interface OnAccountHeaderSelectionViewClickListener {
        public boolean onClick(View var1, IProfile var2);
    }

    public static interface OnAccountHeaderProfileImageListener {
        public boolean onProfileImageClick(View var1, IProfile var2, boolean var3);

        public boolean onProfileImageLongClick(View var1, IProfile var2, boolean var3);
    }

    public static interface OnAccountHeaderItemLongClickListener {
        public boolean onProfileLongClick(View var1, IProfile var2, boolean var3);
    }

    public static interface OnAccountHeaderListener {
        public boolean onProfileChanged(View var1, IProfile var2, boolean var3);
    }
}

