/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.iconics;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.appcompat.content.res.AppCompatResources;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.utils.IconicsConvertersKt;
import com.mikepenz.iconics.utils.IconicsDrawableExtensionsKt;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004\u00a8\u0006\u0018"}, d2={"Lcom/mikepenz/materialdrawer/iconics/IconicsImageHolder;", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "iicon", "Lcom/mikepenz/iconics/typeface/IIcon;", "(Lcom/mikepenz/iconics/typeface/IIcon;)V", "<set-?>", "getIicon", "()Lcom/mikepenz/iconics/typeface/IIcon;", "setIicon$materialdrawer_iconics", "applyTo", "", "imageView", "Landroid/widget/ImageView;", "tag", "", "decideIcon", "Landroid/graphics/drawable/Drawable;", "ctx", "Landroid/content/Context;", "iconColor", "Landroid/content/res/ColorStateList;", "tint", "paddingDp", "", "materialdrawer-iconics"})
public final class IconicsImageHolder
extends ImageHolder {
    @Nullable
    private IIcon iicon;

    public IconicsImageHolder(@NotNull IIcon iicon) {
        Intrinsics.checkNotNullParameter((Object)iicon, (String)"iicon");
        this.iicon = iicon;
    }

    @Nullable
    public final IIcon getIicon() {
        return this.iicon;
    }

    public final void setIicon$materialdrawer_iconics(@Nullable IIcon iIcon) {
        this.iicon = iIcon;
    }

    public boolean applyTo(@NotNull ImageView imageView, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        IIcon ii = this.iicon;
        Uri uri = this.getUri();
        if (uri != null) {
            boolean consumed = DrawerImageLoader.Companion.getInstance().setImage(imageView, uri, tag);
            if (!consumed) {
                imageView.setImageURI(uri);
            }
        } else if (this.getIcon() != null) {
            imageView.setImageDrawable(this.getIcon());
        } else if (this.getBitmap() != null) {
            imageView.setImageBitmap(this.getBitmap());
        } else if (this.getIconRes() != -1) {
            imageView.setImageResource(this.getIconRes());
        } else if (ii != null) {
            Context context = imageView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageView.context");
            imageView.setImageDrawable((Drawable)IconicsDrawableExtensionsKt.actionBar((IconicsDrawable)new IconicsDrawable(context, ii)));
        } else {
            imageView.setImageBitmap(null);
            return false;
        }
        return true;
    }

    @Nullable
    public Drawable decideIcon(@NotNull Context ctx, @NotNull ColorStateList iconColor, boolean tint, int paddingDp) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)iconColor, (String)"iconColor");
        Drawable icon = this.getIcon();
        IIcon ii = this.iicon;
        Uri uri = this.getUri();
        if (ii != null) {
            icon = (Drawable)new IconicsDrawable(ctx, ii).apply((Function1)new Function1<IconicsDrawable, Unit>(iconColor, paddingDp){
                final /* synthetic */ ColorStateList $iconColor;
                final /* synthetic */ int $paddingDp;
                {
                    this.$iconColor = $iconColor;
                    this.$paddingDp = $paddingDp;
                    super(1);
                }

                public final void invoke(@NotNull IconicsDrawable $this$apply) {
                    Intrinsics.checkNotNullParameter((Object)$this$apply, (String)"$this$apply");
                    $this$apply.setColorList(this.$iconColor);
                    IconicsConvertersKt.setSizeDp((IconicsDrawable)$this$apply, (int)24);
                    IconicsConvertersKt.setPaddingDp((IconicsDrawable)$this$apply, (int)this.$paddingDp);
                }
            });
        } else if (this.getIconRes() != -1) {
            icon = AppCompatResources.getDrawable((Context)ctx, (int)this.getIconRes());
        } else if (uri != null) {
            try {
                InputStream inputStream = ctx.getContentResolver().openInputStream(uri);
                icon = Drawable.createFromStream((InputStream)inputStream, (String)uri.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (icon != null && tint && this.iicon == null) {
            icon = icon.mutate();
            icon.setColorFilter(iconColor.getDefaultColor(), PorterDuff.Mode.SRC_IN);
        }
        return icon;
    }
}

